#pragma once

#include "CharacterException.h"

using System::String;

namespace AnimationTesting
{
	public ref class CharacterException : public System::Exception
	{
	public:
		CharacterException(String^ characterName, String^ message);

		property String^ CharacterName
		{
			String^ get();
		}

	private:
		String^ m_characterName;
	};

	public ref class CharacterAssertException : public CharacterException
	{
	public:
		CharacterAssertException(String^ characterName, String^ condition, String^ message, String^ fileName, int m_fileLineNumber);

		property String^ Condition
		{
			String^ get();
		}

		property String^ FileName
		{
			String^ get();
		}

		property int FileLineNumber
		{
			int get();
		}

	private:
		String^ m_condition;
		String^ m_fileName;
		int m_fileLineNumber;
	};
}
