#include "StdAfx.h"
#include "Engine.h"
#include "TestClass.h"
#include "TestContext.h"
#include "TestContextRegistry.h"

#include <IEngine.h>
#include <Windows.h>

using namespace System;
using namespace AnimationTesting;
using namespace CryAnimationTesting;
using namespace CryAnimationTesting::Wrapper;

namespace 
{
	HMODULE LoadModule(String^ binaries);
	String^ ExtractRootDir(String^ binaries);
}

Engine::Engine(String^ binaries)
	: m_engine(0)
	, m_testContestRegistry(new TestContextRegistry())
{
	HMODULE module = LoadModule(binaries);

	FARPROC create = ::GetProcAddress(module, "CryAnimationTestingCreate");
	if (!create)
		throw gcnew Exception("CryAnimationTestingCreate not found in module");
	
	IntPtr binariesMarshaled = Runtime::InteropServices::Marshal::StringToHGlobalAnsi(binaries);
	m_engine = reinterpret_cast<CryAnimationTesting::CreateEngine>(create)();
	m_engine->Initialize((char*)(void*)binariesMarshaled);
	Runtime::InteropServices::Marshal::FreeHGlobal(binariesMarshaled);
}

Engine::~Engine()
{
	delete m_testContestRegistry;
}

CryAnimationTesting::IEngine* Engine::GetIEngine()
{
	return m_engine;
}

TestClass^ Engine::FindAnimationTestClass(String^ name)
{
	pin_ptr<const wchar_t> testClassName = PtrToStringChars(name);
	ITestClass* testClass = m_engine->FindAnimationTestClass(testClassName);
	TestClass^ res = nullptr;
	if (testClass)
		res = gcnew TestClass(testClass);

	return res;
}

void Engine::RegisterTestContext(TestContext^ testContext)
{
	return m_testContestRegistry->Register(testContext);
}

void Engine::UnregisterTestContext(TestContext^ testContext)
{
	m_testContestRegistry->Unregister(testContext);
}

TestContext^ Engine::GetTestContext(ITestContext* testContext)
{
	return m_testContestRegistry->Get(testContext);
}

namespace 
{
	HMODULE LoadModule(String^ binaries)
	{
		String^ rootDir = ExtractRootDir(binaries);
		String^ currentDirectory = Environment::CurrentDirectory;
		Environment::CurrentDirectory = IO::Path::Combine(rootDir, binaries);
		HMODULE module = ::LoadLibrary(L"CryAnimationTesting.dll");
		Environment::CurrentDirectory = currentDirectory;
		if (!module)
			throw gcnew Exception("CryAnimationTesting.dll not loaded");

		return module;
	}

	String^ ExtractRootDir(String^ binaries)
	{
		wchar_t moduleFileName[256];
		GetModuleFileName(GetModuleHandle(0), moduleFileName, 256);
		String^ rootDir = gcnew String(moduleFileName);
		Int32 lastIndex = rootDir->LastIndexOf("Bin");
		if (lastIndex == -1)
			throw gcnew Exception("Bin not found in moduleFileName");

		return rootDir->Substring(0, lastIndex);
	}
}
