#pragma once

using System::String;

namespace CryAnimationTesting
{
	struct IEngine;
	struct ITestContext;

	namespace Wrapper
	{
		ref class TestClass;
		class TestContextRegistry;
	}
}

namespace AnimationTesting
{
	using namespace CryAnimationTesting;
	using namespace CryAnimationTesting::Wrapper;

	ref class TestContext;

	public ref class Engine
	{
	public:
		Engine(String^ binaries);
		~Engine();

		IEngine* GetIEngine();

		TestClass^ FindAnimationTestClass(String^ name);
		void RegisterTestContext(TestContext^ testContext);
		void UnregisterTestContext(TestContext^ testContext);
		TestContext^ GetTestContext(ITestContext* testContext);

	private:
		IEngine* m_engine;
		TestContextRegistry* m_testContestRegistry;			
	};
}
