#include "Stdafx.h"
#include "TestContext.h"
#include "Character.h"
#include "Engine.h"
#include "TestConfigElement.h"
#include <IEngine.h>
#include <ITestContext.h>
#include <ICharacter.h>
#include <IConfigElement.h>

using namespace System;
using namespace System::Runtime::InteropServices;

namespace AnimationTesting
{
	TestContext::TestContext(Engine^ engine, String^ testName, CryAnimationTesting::Wrapper::Character^ character, String^ animName)
		: m_engine(engine)
	{
		m_testName = testName;
		IntPtr animNameStr = Marshal::StringToHGlobalAnsi(animName);
		m_testContext = engine->GetIEngine()->CreateTestContext(character->GetICharacter(), (char*)(void*)animNameStr);
		Marshal::FreeHGlobal(animNameStr);
		engine->RegisterTestContext(this);
	}

	TestContext::~TestContext()
	{
		m_engine->UnregisterTestContext(this);
		m_testContext->Release();
	}

	CryAnimationTesting::ITestContext* TestContext::GetITestContext()
	{
		return m_testContext;
	}

	String^ TestContext::TestName::get()
	{
		return m_testName;
	}

	String^ TestContext::AnimationName::get()
	{
		return gcnew String(m_testContext->GetAnimationName());
	}

	String^ TestContext::CharacterName::get()
	{
		return gcnew String(m_testContext->GetCharacter()->GetCharacterName());
	}

	CryAnimationTesting::Wrapper::TestConfigElement^ TestContext::AddConfigElement(String^ name)
	{
		CryAnimationTesting::IConfigElementCollection* configElementCollection = m_testContext->GetConfigElementCollection();

		IntPtr nameStr = Marshal::StringToHGlobalAnsi(name);
		CryAnimationTesting::IConfigElement* configElement = configElementCollection->Add((char*)(void*)nameStr);
		Marshal::FreeHGlobal(nameStr);

		return gcnew CryAnimationTesting::Wrapper::TestConfigElement(configElement);
	}
}
