#pragma once

using System::String;

namespace CryAnimationTesting
{
	struct ITestContext;

	namespace Wrapper
	{
		ref class Character;
		ref class TestConfigElement;
	}
}

namespace AnimationTesting
{
	ref class Engine;

	public ref class TestContext
	{
	public:
		TestContext(Engine^ engine, String^ testName, CryAnimationTesting::Wrapper::Character^ character, String^ animName);
		~TestContext();

		CryAnimationTesting::ITestContext* GetITestContext();

		property String^ AnimationName
		{
			String^ get();
		}

		property String^ CharacterName
		{
			String^ get();
		}

		property String^ TestName
		{
			String^ get();
		}

		CryAnimationTesting::Wrapper::TestConfigElement^ AddConfigElement(String^ name);

	private:
		Engine^ m_engine;
		String^ m_testName;
		CryAnimationTesting::ITestContext* m_testContext;
	};
}
