#include "Stdafx.h"
#include "TestContextRegistry.h"
#include "TestContext.h"
using namespace AnimationTesting;
using namespace CryAnimationTesting;
using namespace CryAnimationTesting::Wrapper;

void TestContextRegistry::Register(TestContext^ testContext)
{
	m_registry.insert(std::make_pair(testContext->GetITestContext(), gcroot<TestContext^>(testContext)));
}

void TestContextRegistry::Unregister(TestContext^ testContext)
{
	m_registry.erase(testContext->GetITestContext());
}

TestContext^ TestContextRegistry::Get(ITestContext* testContext)
{
	Registry::iterator it = m_registry.find(testContext);
	return (it != m_registry.end()) ? it->second : nullptr;
}
