#pragma once

using System::String;
#include <map>
#include <vcclr.h>

namespace AnimationTesting
{
	ref class TestContext;
}

namespace CryAnimationTesting
{
	struct ITestContext;

	namespace Wrapper
	{
		class TestContextRegistry
		{
			typedef std::map<CryAnimationTesting::ITestContext*, gcroot<AnimationTesting::TestContext^> > Registry;
		public:
			void Register(AnimationTesting::TestContext^ testContext);
			void Unregister(AnimationTesting::TestContext^ testContext);
			AnimationTesting::TestContext^ Get(ITestContext* testContext);
		private:
			Registry m_registry;
		};
	}
}
