#include "StdAfx.h"
#include <ITestListener.h>
#include "TestListener.h"
#include "TestRunInfo.h"
#include "TestContext.h"
#include "Engine.h"

#include <vcclr.h>

using namespace AnimationTesting;
using namespace CryAnimationTesting;
using namespace CryAnimationTesting::Wrapper;

namespace 
{
	class TestListenerDispatcher : public ITestListener
	{
	public:
		TestListenerDispatcher(Engine^ engine, TestListener^ managedListener)
			: m_engine(engine)
			, m_managedListener(managedListener)
		{
			m_managedListener = managedListener;
		}

		virtual void TestPassed(const ITestContext& testContext, const wchar_t* testName)
		{
			m_managedListener->TestPassed(m_engine->GetTestContext(const_cast<ITestContext*>(&testContext)), gcnew TestRunInfo(gcnew String(testName)));
		}

		virtual void TestFailed(const ITestContext& testContext, const wchar_t* testName, const wchar_t* condition, const wchar_t* message, const wchar_t* fileName, int line)
		{
			m_managedListener->TestFailed(m_engine->GetTestContext(const_cast<ITestContext*>(&testContext)), gcnew TestRunInfo(gcnew String(testName), gcnew String(condition), gcnew String(message), gcnew String(fileName), line));
		}

	private:
		gcroot<Engine^> m_engine;
		gcroot<TestListener^> m_managedListener;
	};
}

TestListener::TestListener(Engine^ engine)
{
	m_listener = new TestListenerDispatcher(engine, this);
}

TestListener::~TestListener()
{
	delete m_listener;
}

ITestListener& TestListener::GetITestListener()
{
	return *m_listener;
}
