#pragma once

namespace AnimationTesting
{
	ref class Engine;
	ref class TestContext;
	ref class TestRunInfo;
}

namespace CryAnimationTesting
{
	struct ITestListener;

	namespace Wrapper
	{
		public ref class TestListener abstract
		{
		public:
			TestListener(AnimationTesting::Engine^ engine);
			virtual ~TestListener();

			ITestListener& GetITestListener();

			virtual void TestPassed(AnimationTesting::TestContext^ testContext, AnimationTesting::TestRunInfo^ testRunInfo) = 0;
			virtual void TestFailed(AnimationTesting::TestContext^ testContext, AnimationTesting::TestRunInfo^ testRunInfo) = 0;

		private:
			ITestListener* m_listener;
		};
	}
}
