#pragma once

using System::String;

namespace AnimationTesting
{
	public ref class TestRunInfo
	{
	private:
		String^ m_testName;
		String^ m_errorCondition;
		String^ m_errorMessage;
		String^ m_fileName;
		int m_fileLineNumber;

	public:
		TestRunInfo(String^ testName)
			: m_testName(testName)
			, m_errorCondition(gcnew String(""))
			, m_errorMessage(gcnew String(""))
			, m_fileName(gcnew String(""))
			, m_fileLineNumber(0)
		{

		}

		TestRunInfo(String^ testName, String^ errorCondition, String^ errorMessage, String^ fileName, int fileLineNumber)
			: m_testName(testName)
			, m_errorCondition(errorCondition)
			, m_errorMessage(errorMessage)
			, m_fileName(fileName)
			, m_fileLineNumber(fileLineNumber)
		{

		}

		property String^ TestName
		{
			String^ get()
			{
				return m_testName;
			}
		}

		property String^ ErrorCondition
		{
			String^ get()
			{
				return m_errorCondition;
			}
		}

		property String^ ErrorMessage
		{
			String^ get()
			{
				return m_errorMessage;
			}
		}

		property String^ FileName
		{
			String^ get()
			{
				return m_fileName;
			}
		}

		property int FileLineNumber
		{
			int get()
			{
				return m_fileLineNumber;
			}
		}
	};
}
