using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace UnitTest
{
	[TestFixture]
	public class CommandLineArgumentsTest
	{
		[Test]
		public void ParseEmptyCommandLineGivesDefaultValuesTest()
		{
			AnimationTesting.CommandLineArguments commandLineArguments = new AnimationTesting.CommandLineArguments();
			commandLineArguments.ParseArguments(new string[0]);

            Assert.AreEqual("..\\..\\Code\\Tools\\AnimationTesting\\CryAnimationTesting\\suite.xml", commandLineArguments.Suite);
			Assert.IsNull(commandLineArguments.Report);
			Assert.AreEqual(@"Bin32", commandLineArguments.Binaries);
		}

		[Test]
		public void ParseReportOptionTest()
		{
			AnimationTesting.CommandLineArguments commandLineArguments = new AnimationTesting.CommandLineArguments();
			commandLineArguments.ParseArguments(new string[] { @"/Report:MyDir\MyFile.xml" } );

			Assert.AreEqual(@"MyDir\MyFile.xml", commandLineArguments.Report);
		}

		[Test]
		public void ParseSuiteOptionTest()
		{
			AnimationTesting.CommandLineArguments commandLineArguments = new AnimationTesting.CommandLineArguments();
			commandLineArguments.ParseArguments(new string[] { @"/Suite:..\../suite4all.xml" });

			Assert.AreEqual(@"..\../suite4all.xml", commandLineArguments.Suite);
		}

		[Test]
		public void ParseBinariesOptionTest()
		{
			AnimationTesting.CommandLineArguments commandLineArguments = new AnimationTesting.CommandLineArguments();
			commandLineArguments.ParseArguments(new string[] { "/Binaries:Bin64" });

			Assert.AreEqual(@"Bin64", commandLineArguments.Binaries);
		}

		[Test]
		public void NotValidArgumentHandlingTest()
		{
			AnimationTesting.CommandLineArguments commandLineArguments = new AnimationTesting.CommandLineArguments();
			try
			{
				commandLineArguments.ParseArguments(new string[] { "/ParamNotValid" });
				Assert.Fail("Exception excepted");
			}
			catch (AnimationTesting.CommandLineArgumentsException exception)
			{
				Assert.AreEqual("Argument not valid: /ParamNotValid", exception.Message);
			}
			catch (Exception)
			{
				Assert.Fail("Not valid exception thrown");
			}
		}
	}
}
