var SHELL = WScript.CreateObject("WScript.Shell");
var FSO = WScript.CreateObject("Scripting.FileSystemObject");

WScript.Quit(Main());

function Log( str )
{
    WScript.Echo( str );
}

// +++++++++++++++++++++++++For reading in other jscripts and then including them+++++++++++++++++++++++++
function ReadFile(file, create)
{ 
	var str = "";
	
	if(!FSO.FileExists(file) && !create)
	{
		Log("Couldn't read file. It doesn't exists!");
		return str;
	}	

	try
	{
	  var fileToRead = FSO.OpenTextFile(file, 1, create);
	  if(!fileToRead.AtEndOfstream)
	  	
		str = fileToRead.ReadAll();
	  	
		fileToRead.Close();
 	  
	  if( str == "")
  		Log("File is empty!");
	}
	catch(e)
	{
		Log("Error while reading file: " + e.description);
	}  
  	
  return str;
}

function UpdateVCProj( filename )
{
	var file, ts, str;

	str = ReadFile(filename, false);
	if (str == "")
	    return;
	    
	var re;
	    
	re = /WarnAsError="true"/g;
	str = str.replace( re,"" );
	
	re = /WarnAsError="false"/g;
	str = str.replace( re,"" );
	
	re = /AdditionalOptions="\/analyze \/Zm200"/g;
	str = str.replace( re,"" );
	
	re = /AdditionalOptions="\/analyze \/Zm300"/g;
	str = str.replace( re,"" );

	re = /Name="VCCLX360CompilerTool"/g;
	str = str.replace( re,"Name=\"VCCLX360CompilerTool\" WarnAsError=\"true\" AdditionalOptions=\"/analyze /Zm300\"" );
	
	file = FSO.GetFile(filename);
	if (file == null)
	    return;

	var readOnly = false;
	// ReadOnly ?
	if (file.attributes & 1)
	{
    	readOnly = true;
		// Clear read only flag.
		file.attributes = file.attributes & (~1);
	}

	// Write updated data into file
	var outfile = FSO.CreateTextFile( filename, true);
	outfile.Write( str );
	outfile.Close();
	Log( filename+" Updated" )
}

function ScanDir( dir )
{
   // Get Current Folder  
   var srcFolder = FSO.GetFolder( dir );
 
   // Get Files in current directory  
   var files = new Enumerator( srcFolder.files );
 
   // Loop through files  
   for(; !files.atEnd(); files.moveNext() )
   {
        
     // You have access to each file one at a time
     // in an entire directory tree. Here we grab
     // the files name and add to our message variable 
      //msg += dir + "\\" + files.item().Name + "\n";
      var index = files.item().Name.indexOf(".vcproj");
      if (index != -1 && index == files.item().Name.length-7)
      {
      	var fileName = dir + "\\" + files.item().Name;
        WScript.Echo( fileName );
        UpdateVCProj( fileName );
      }
   }
   
   // Get any sub folders to current directory  
   var esub = new Enumerator( srcFolder.SubFolders );
   
   // Loop through sub folder list and scan
   // through a recursive call to this function
   for(; !esub.atEnd(); esub.moveNext() )
   {
      var f = FSO.GetFolder( esub.item() );
      var subDir = dir + "\\" + f.Name;
      ScanDir( subDir );
   }
}

function Main()
{
    // Get Name of the project file to update from arguments
	if (WScript.Arguments.length > 0)
	{
	    var projectFile = WScript.Arguments(0);
	    UpdateVCProj( projectFile );
	    //ScanDir( projectFile );
	}
	else
	{
	    Log( "Project file not specified, use /project property" )
	}
	
    //UpdateVCProj( "Cry3DEngine.vcproj" );
}