var SHELL = WScript.CreateObject("WScript.Shell");
var FSO = WScript.CreateObject("Scripting.FileSystemObject");

var gsLatestChangeListIdFile = "LastUsedChangeListId.txt";
var gsCopyDestination = "Changes";
var gsP4GlobalOptions = "";
var gsp4ClientName = "build";
var gsTargetDir = "";

WScript.Quit(Main());



function Main()
{
	var sScriptHost = WScript.FullName;
	if (sScriptHost.search(/cscript.exe/i) == "-1")
	{
		SHELL.Popup(
			"Invalid script Host - This application is made for commandline use only\n" +
			"Please start the script with \"cscript\" before the scriptname e.g.: cscript <ScriptName>\n",
      0, "Error", 0);	                    
	 	return -1;
	}
	
	HandleArguments();
	
	var sLatestId = GetLatestP4ChangeListId();
	Log("LatestID = " + sLatestId);
	var sLastId = GetLastUsedChangeListId();
	Log("LastID = " + sLastId);
	var aChangedDepotFiles = GetChangedP4FilesBetweenChangeLists(sLastId, sLatestId);
	if (aChangedDepotFiles.length > 0)
	{
		var aLocalFiles = GetLocalFilesFromDepotFiles(aChangedDepotFiles);
		var aRelativeFiles = GetRelativePaths(aLocalFiles);
		CopyFiles(aRelativeFiles);
	}
	else
		Log("no files copied");
	UpdateLastUsedChangeListId(sLatestId);
	return 0;
}



function CopyFiles(aFiles)
{
	var aParts;
	var sTemp;
	for (var i = 0; i < aFiles.length; ++i)
	{
		Log("copying \"" + aFiles[i] + "\"");
		sTemp = "";
		aParts = aFiles[i].split("\\");
		for (var j = 0; j < aParts.length - 1; ++j)
		{
			sTemp += "\\" + aParts[j];
			if (!FSO.FolderExists(gsTargetDir + sTemp))
				FSO.CreateFolder(gsTargetDir + sTemp);
		}
		FSO.CopyFile(aFiles[i], gsTargetDir + "\\" + aFiles[i], true);
	}
}



function ExitWithError(sError)
{
	Log("Error: " + sError);
	WScript.Quit(-1);
}



function GetRelativePaths(aFiles)
{
	for (var i = 0; i < aFiles.length; ++i)
		if (aFiles[i].indexOf(SHELL.CurrentDirectory) == 0)
			aFiles[i] = aFiles[i].substr(SHELL.CurrentDirectory.length + 1, aFiles[i].length - SHELL.CurrentDirectory.length - 1);
		else
			ExitWithError("file not in current directory:\n" + aFiles[i]);
	return aFiles;
}



function HandleArguments()
{
	var sClient = GetArgument("client");
	if (sClient != "")
	{
		gsP4GlobalOptions += " -c " + sClient;
		gsp4ClientName = sClient;
	}
	
	gsTargetDir = GetArgument("targetdir");
	if (gsTargetDir == "")
		ExitWithError("parameter targetdir required to run");
}



function GetArgument(sName)
{
	if (WScript.Arguments.Named.Exists(sName))
		return WScript.Arguments.Named.Item(sName);
	return "";
}



function GetLatestP4ChangeListId()
{
	var sRunResult = P4("changes -m 1");
	var aParsed = sRunResult.match(/\d+/);
	return aParsed[0];
}



function GetLastUsedChangeListId()
{
	if (FSO.FileExists(gsLatestChangeListIdFile))
	{
		var oFile = FSO.OpenTextFile(gsLatestChangeListIdFile, 1);
		var sId = oFile.ReadAll();
		if (sId && sId != "")
			return sId;
	}
	return "0";
}



function GetChangedP4FilesBetweenChangeLists(sFrom, sTo)
{
	var sRunResult = P4("files //" + gsp4ClientName + "/...@" + sFrom + "," + sTo);
	var aFiles = sRunResult.match(/\/\/.+\#/g);
	if (!aFiles)
		aFiles = new Array();
	else
		for (var i = 0; i < aFiles.length; ++i)
			aFiles[i] = aFiles[i].substr(0, aFiles[i].length - 1);
	return aFiles;
}



function UpdateLastUsedChangeListId(sChangeListId)
{
	var oFile = FSO.CreateTextFile(gsLatestChangeListIdFile, true);
	oFile.Write(sChangeListId);
	oFile.Close();
}



function GetLocalFilesFromDepotFiles(aFiles)
{
	var aLocalFiles = new Array();
	var sRunResult;
	var iPos;
	var sFile;
	for (var i = 0; i < aFiles.length; ++i)
	{
		sRunResult = P4("where \"" + aFiles[i] + "\"", true);
		iPos = sRunResult.indexOf(':') - 1;
		sFile = sRunResult.substr(iPos, sRunResult.length - iPos - 2);
		aLocalFiles.push(sFile);
	}
	return aLocalFiles;
}



function Log(sText)
{
	WScript.Echo(sText);
}



function Run(sCmdLine)
{
	var oExec = SHELL.Exec(sCmdLine);
	while (oExec.Status == 0)
		WScript.Sleep(100);
	return oExec.StdOut.ReadAll() + oExec.StdErr.ReadAll();
}



function P4(sParams, bQuiet)
{
	var sCall = "p4 " + gsP4GlobalOptions + " " + sParams;
	if (!bQuiet)
	{
		Log(sCall);
		Log("----------");
	}
	var sResult = Run(sCall);
	if (!bQuiet)
	{
		Log(sResult);
		Log("----------");
	}
	return sResult;
}

