#ifndef DATAQUEUE_H
#define DATAQUEUE_H

#include "datarange.h"
#include <iostream>

class CDataQueue
{
public:
	void Insert( CDataRange range );
	bool Remove( unsigned index );
	unsigned Count() const;
	bool HasIslands( unsigned lastPacket );
	void Merge( const CDataQueue& other );

	unsigned Front()
	{
		return m_ranges.front().Start();
	}

	void Pop()
	{
		if (m_ranges.front().Start() + 1 == m_ranges.front().End())
			m_ranges.pop_front();
		else
			m_ranges.front() = CDataRange(m_ranges.front().Start()+1, m_ranges.front().End());
	}

	bool Empty()
	{
		return m_ranges.empty();
	}

	unsigned Next()
	{
		unsigned out = Front();
		Pop();
		return out;
	}

	friend inline BOutputStream& operator<<( BOutputStream& out, const CDataQueue& q )
	{
		out << unsigned(q.m_ranges.size());
		for (MyList::const_iterator iter = q.m_ranges.begin(); iter != q.m_ranges.end(); ++iter)
		{
			out << *iter;
		}
		return out;
	}
	friend inline BInputStream& operator>>( BInputStream& in, CDataQueue& q )
	{
		unsigned count;
		in >> count;
		while (count--)
		{
			CDataRange r;
			in >> r;
			q.Insert( r );
		}
		return in;
	}

	size_t BinSize() const
	{
		return m_ranges.size() * sizeof(unsigned) * 2;
	}

	void Clear()
	{
		m_ranges.clear();
	}

	void Dump( const char * hdr = NULL, std::ostream& out = std::cout ) const;

private:
	typedef std::list<CDataRange> MyList;
	MyList m_ranges;
};

#endif
