#include "hash.h"
#include "md5.h"
#include <time.h>

CHash::CHash( CFile& file, IHashProgressCallback * pProgress )
{
	time_t lastProgress = 0;

	file.Seek( 0, SEEK_END );
	fpos_t length = file.GetPos();
	file.SetPos( 0 );

	static const size_t BS = 16384;
	md5_byte_t buf[BS];

	md5_state_t ctx;
	md5_init( &ctx );

	while (length)
	{
		if (pProgress && time(NULL) != lastProgress)
		{
			pProgress->OnProgress();
			lastProgress = time(NULL);
		}

		size_t readAmt = (size_t) min( fpos_t(BS), length );
		file.Read( buf, readAmt );
		md5_append( &ctx, buf, int(readAmt) );
		length -= readAmt;
	}

	md5_finish( &ctx, (unsigned char *)m_hash );
}
