#ifndef NOTIFYICON_H
#define NOTIFYICON_H

#include "iconhandle.h"
#include "menuhandle.h"
#include "mutex.h"
#include <memory>

static const UINT uidIcon = 0;
static const UINT msgIcon               = WM_APP + 1;
static const UINT msgUpdateNotification = WM_APP + 2;
static const UINT msgUpdateTip          = WM_APP + 3;

class CClientThread;

class CNotifyIcon
{
public:
	CNotifyIcon(HWND hwnd);
	void Info( const std::string& title, const std::string& msg, DWORD flags, UINT timeout = 10000 );
	~CNotifyIcon();

	void OnRButtonDown();
	void OnContextMenu() { OnRButtonDown(); }
	void OnCommand( int command );
	void OnUpdateNotification();
	void OnUpdateTip();

	void SetNotification( const std::string& title, const std::string& text );
	void SetTip( const std::string& tip );

	static CNotifyIcon * Get() { return m_singleton; }

private:
	CNotifyIcon( const CNotifyIcon& );
	CNotifyIcon& operator=( const CNotifyIcon& );

	void PostWindowMessage( UINT msg, WPARAM wparam = 0, LPARAM lparam = 0 )
	{
		PostMessage( m_hwnd, msg, wparam, lparam );
	}

	struct SNotifyIconData;
	CIconHandle m_notReady;
	CMenuHandle m_contextMenu;
	HWND m_hwnd;
	std::auto_ptr<CClientThread> m_pThread;

	static CNotifyIcon * m_singleton;

	// any data from here is shared between the client thread & the ui thread
	CMutex m_mutex;

	std::string m_notifyTitle;
	std::string m_notifyText;
	std::string m_tip;
};

#endif
