#ifndef PTR_H
#define PTR_H

#include <functional>

class CReffed
{
public:
	CReffed() : m_nRefs(0) {}
	virtual ~CReffed() {}

	void Acquire() { m_nRefs++; }
	void Release() { if (0 == --m_nRefs) delete this; }

private:
	int m_nRefs;
};

template <class T>
class Ptr
{
public:
	explicit Ptr( T* p ) : m_p(p) { if (p) p->Acquire(); }
	~Ptr() { if (m_p) m_p->Release(); }
	Ptr( const Ptr& ptr ) : m_p(ptr.m_p) { if (m_p) m_p->Acquire(); }
	Ptr& operator=( const Ptr& other )
	{
		Ptr temp(other);
		std::swap(temp.m_p, m_p);
		return *this;
	}
	T* operator->() const { return m_p; }
	friend T* GetPtr( const Ptr<T>& p ) { return p.m_p; }
private:
	T* m_p;
};

namespace std
{
	template <class T>
	struct less< Ptr<T> > : public binary_function<Ptr<T>, Ptr<T>, bool>
	{
		bool operator()( const Ptr<T>& a, const Ptr<T>& b )
		{
			return GetPtr(a) < GetPtr(b);
		}
	};
}

#endif
