#ifndef RECEIVEFILE_H
#define RECEIVEFILE_H

#include <string>
#include <memory>
#include "hash.h"
#include "bstream.h"
#include "fileio.h"
#include "dataqueue.h"
#include "ptr.h"

struct IClientListener;

class CReceiveFile : public CReffed
{
public:
	CReceiveFile( const std::string& filename, unsigned packets, const CHash& hash );

	bool Complete( IHashProgressCallback * pProgress, IClientListener * pListener );
	void Timeout( IClientListener * pListener );
	bool Receive( unsigned pkt, const void * data, size_t sz );
	std::string GetProgressMessage();

	bool GetPending( BOutputStream& out )
	{
		m_queue.Dump();
		out << m_queue;
		return m_queue.HasIslands(m_nPackets);
	}

private:
	std::string m_filename;
	std::auto_ptr<CFile> m_file;
	CDataQueue m_queue;
	CHash m_hash;
	unsigned m_nPackets;
	bool m_bValidated;
};

#endif
