// BuildManager.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "BuildManager.h"
#include "BuildManagerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

/*

  CBuildManagerCommandLine

*/

class CBuildManagerCommandLine : public CCommandLineInfo
{
public:
	CBuildManagerCommandLine()
	{
		m_bNoBinaries = false;
		m_bNoLevels = false;
	}

	~CBuildManagerCommandLine()
	{
	}

public:
	void Execute(CBuildManagerDlg &buildManager)
	{
		if (m_project.empty() || m_target.empty() || m_path.empty())
			return;

		buildManager.SetAutoUpload(m_project.c_str(), m_target.c_str(), m_path.c_str(),
			m_bNoBinaries, m_bNoLevels, m_bNoSystemCfg);
	}

	// CCommandLineInfo
public:
	virtual void ParseParam(const char* pszParam, BOOL bFlag, BOOL bLast)
	{
		static string *pSave = NULL;
		if (pSave)
		{
			pSave->clear();
			if (bFlag)
				*pSave = "/";
			*pSave += pszParam;
			pSave = NULL;
		}

		size_t length = ::strlen(pszParam);
		if (_strnicmp(pszParam, "project", length) == 0)
			pSave = &m_project;
		else if (_strnicmp(pszParam, "target", length) == 0)
			pSave = &m_target;
		else if (_strnicmp(pszParam, "path", length) == 0)
			pSave = &m_path;
		else if (bFlag && _strnicmp(pszParam, "NoBinaries", length) == 0)
			m_bNoBinaries = true;
		else if (bFlag && _strnicmp(pszParam, "NoLevels", length) == 0)
			m_bNoLevels = true;
		else if (bFlag && _strnicmp(pszParam, "NoSystemCfg", length) == 0)
			m_bNoSystemCfg = true;
	}

private:
	string m_project;
	string m_target;
	string m_path;

	bool m_bNoBinaries;
	bool m_bNoLevels;
	bool m_bNoSystemCfg;
};

/*

  CBuildManagerApp

*/

CBuildManagerApp theApp;

//

BEGIN_MESSAGE_MAP(CBuildManagerApp, CWinApp)
	ON_COMMAND(ID_HELP, &CWinApp::OnHelp)
END_MESSAGE_MAP()

//

CBuildManagerApp::CBuildManagerApp()
{
}

//

BOOL CBuildManagerApp::InitInstance()
{
	// InitCommonControlsEx() is required on Windows XP if an application
	// manifest specifies use of ComCtl32.dll version 6 or later to enable
	// visual styles.  Otherwise, any window creation will fail.
	INITCOMMONCONTROLSEX InitCtrls;
	InitCtrls.dwSize = sizeof(InitCtrls);
	// Set this to include all the common control classes you want to use
	// in your application.
	InitCtrls.dwICC = ICC_WIN95_CLASSES;
	InitCommonControlsEx(&InitCtrls);

	CWinApp::InitInstance();

	AfxInitRichEdit();

	CoInitialize(NULL);

	CBuildManagerCommandLine buildManagerCommandLine;
	ParseCommandLine(buildManagerCommandLine);

	CBuildManagerDlg dialog;

	buildManagerCommandLine.Execute(dialog);

	m_pMainWnd = &dialog;
	dialog.DoModal();

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}
