// BuildManagerDlg.h : header file
//

#pragma once

#include "ProjectManager.h"

#define COMMAND_LIST_LENGTH 50000
#define NO_LEVEL	(-666)

// CBuildManagerDlg dialog
class CBuildManagerDlg : public CDialog, public RemoteControl::IConnectionManagerCallback
{
private:
	struct CControlDesc
	{
	public:
		enum ESizeFlag
		{
			eSF_Left	= 1<<0,
			eSF_Right	= 1<<1,
			eSF_Top		= 1<<2,
			eSF_Bottom	= 1<<3,
		};

	public:
		CControlDesc() :
		pWindow(NULL), sizeFlags(NULL), sizeRect(CRect())
		{
		}

		CControlDesc(CWnd &window, unsigned int sizeFlags) :
		pWindow(&window), sizeFlags(sizeFlags)
		{
			if (!sizeFlags)
				return;

			CRect r;
			window.GetParent()->GetClientRect(r);

			WINDOWPLACEMENT wp;
			window.GetWindowPlacement(&wp);

			if (sizeFlags & eSF_Left)
				sizeRect.left =  r.Width() - wp.rcNormalPosition.left;
			if (sizeFlags & eSF_Right)
				sizeRect.right =  r.Width() - wp.rcNormalPosition.right;
			if (sizeFlags & eSF_Top)
				sizeRect.top =  r.Height() - wp.rcNormalPosition.top;
			if (sizeFlags & eSF_Bottom)
				sizeRect.bottom =  r.Height() - wp.rcNormalPosition.bottom;
		}
	
	public:
		CWnd *pWindow;
		unsigned int sizeFlags;
		CRect sizeRect;
	};

private:
	static void __stdcall CheckBuildUploadFinished(HWND, UINT, UINT_PTR, DWORD);

private:
	static UINT s_checkBuildUploadFinishedTimer;

public:
	void SetAutoUpload(const char *project, const char *target, const char *path, bool bNoBinaries, bool bNoLevels,bool bNoSystemCfg);

	void LogOutput(const char *text); // TODO: Should be private.

private:
	void ConfigWrite();
	void ConfigRead();

	void EnableControlsUpload();
	void EnableControlsAuto();

	void ProjectConfigWrite();
	void ProjectConfigRead();

	void ProjectsRefresh();
	void ProjectActive(size_t index);

	void ConnectionsRefresh();
public:
	void ConnectionsRefreshCallback();
private:
	void ConnectionActive(size_t index);
	void ConnectionRefreshCurrent();
	void ConnectionPathRefresh(const char *path);

	void BuildsRefresh();
	void SetFilterBuilds(bool filterbuilds);

	void CommandListClear();
	bool CommandListCreate();
	bool CommandComplete();

	void AutoUpload();

private:
	RemoteControl::IConnection *m_pConnection;

	char m_commandList[COMMAND_LIST_LENGTH];
	bool m_commandListInitialized;
	CString m_commandListFind;
	const char *m_commandListLast;

	// IConnectionManagerCallback
private:
	void OnConnectionManagerLog(const char *text);

public:
	CBuildManagerDlg(CWnd *pParent = NULL);
	~CBuildManagerDlg();

// Dialog Data
public:
	enum { IDD = IDD_BuildManager_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	virtual BOOL PreTranslateMessage(MSG *pMsg);

protected:
	CRect m_rect;
	HICON m_hIcon;

	CComboBox	m_projects;
	CButton		m_projectsRefresh;
	CComboBox	m_connections;
	CButton		m_connectionsRefresh;
	CComboBox	m_builds;
	CButton		m_buildsRefresh;
	CStatic		m_connectionBuilds;
	CEdit		m_connectionPath;
	CComboBox	m_connectionLevels;

	CButton m_noSystemCfg;
	CButton m_frontend;
	CButton m_noBinaries;
	CButton m_noLevels;
	CButton m_cleanBuild;
	CButton m_filterBuilds;

	CButton m_upload;
	CButton m_launch;

	CRichEditCtrl m_log;
	CEdit m_command;

	std::vector<CControlDesc> m_controlDescs;

	string m_mruProject;
	string m_mruConnection;
	string m_mruBuild;
	string m_mruLevel;

	string m_connectionPrevious;

	CRITICAL_SECTION m_logCriticalSection;

	bool m_bAutoUpload;
	string m_autoUploadProject;
	string m_autoUploadTarget;
	string m_autoUploadPath;
	unsigned int m_autoUploadExclude;
	int m_timer;

	// Generated message map functions
protected:
	virtual BOOL OnInitDialog();
	afx_msg void OnSizing(UINT nSide, LPRECT lpRect);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnEraseBkgnd(CDC *pDC);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnCbnSelchangeProjects();
	afx_msg void OnBnClickedProjectsRefresh();
	afx_msg void OnCbnSelchangeConnections();
	afx_msg void OnBnClickedConnectionsRefresh();
	afx_msg void OnBnClickedBuildsRefresh();
	afx_msg void OnEnChangeConnectionPath();
	afx_msg void OnCbnSelchangeConnectionLevels();
	afx_msg void OnBnClickedUpload();
	afx_msg void OnBnClickedLaunch();
	afx_msg void OnBnClickedFlag();
	afx_msg void OnEnChangeLog();
};
