#include "stdafx.h"
#include "ConnectionLocal.h"
#include "FileUtil.h"

//#define USE_SHELLCOPY

using namespace RemoteControl;
/*

  CConnectionLocal

*/

ConnectionRegister(Local,
	NULL,
	NULL,
	&CConnectionLocal::RefreshConnections);

//

bool CConnectionLocal::RefreshConnections()
{
	static CConnectionLocal instance;
	CConnectionManager::Instance().AddConnection(&instance);
	return true;
}

//

CConnectionLocal::CConnectionLocal()
{
}

CConnectionLocal::~CConnectionLocal()
{
}

// IConnection

bool CConnectionLocal::SendCommand(const char *command, char *response, size_t &length)
{
	return false;
}

bool CConnectionLocal::DirectoryList(const char *remotePath, std::vector<string> &directories)
{
	string s = remotePath;
	::append_if_not_last(s, '/', "/\\");
	s += "*.*";

	WIN32_FIND_DATA findData;
	HANDLE hR = ::FindFirstFile(s.c_str(), &findData);
	while (true)
	{
		if ((findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == FILE_ATTRIBUTE_DIRECTORY)
		{
			if (::strcmp(findData.cFileName, ".") != 0 &&
				::strcmp(findData.cFileName, "..") != 0)
			{
				directories.push_back(findData.cFileName);
			}
		}

		if (!::FindNextFile(hR, &findData))
			break;
	}
	if (hR)
		::FindClose(hR);

	return true;
}

bool CConnectionLocal::FileCopyTo(const char *localSource, const char *remoteDestination, bool bSilent)
{
#if defined(USE_ROBOCOPY)

	size_t pathLength = Path::GetLengthWithoutFile(localSource);

	string command = "C:/robocopy.exe ";
	command.append(localSource, pathLength);
	command += " ";
	command.append(remoteDestination, Path::GetLengthWithoutFile(remoteDestination));
	command += " \"";
	command += &localSource[pathLength];
	command += "\"";

	SECURITY_ATTRIBUTES securityAttributes;
	::ZeroMemory(&securityAttributes, sizeof(securityAttributes));
	securityAttributes.nLength = sizeof(securityAttributes); 
	securityAttributes.bInheritHandle = TRUE;
	securityAttributes.lpSecurityDescriptor = NULL;

	HANDLE hChildStdOutRead, hChildStdOutWrite;
	::CreatePipe(&hChildStdOutRead, &hChildStdOutWrite, &securityAttributes, NULL);
	::SetHandleInformation(hChildStdOutRead, HANDLE_FLAG_INHERIT, NULL);

	HANDLE hChildStdInRead, hChildStdInWrite;
	::CreatePipe(&hChildStdInRead, &hChildStdInWrite, &securityAttributes, NULL);
	::SetHandleInformation(hChildStdInWrite, HANDLE_FLAG_INHERIT, NULL);

	STARTUPINFO startUpInfo;
	::ZeroMemory(&startUpInfo, sizeof(startUpInfo));
	startUpInfo.cb = sizeof(startUpInfo);
	startUpInfo.dwX = 100;
	startUpInfo.dwY = 100;
	startUpInfo.hStdError = hChildStdOutWrite;
	startUpInfo.hStdOutput = hChildStdOutWrite;
	startUpInfo.hStdInput = hChildStdInRead;
	startUpInfo.dwFlags = STARTF_USESTDHANDLES | STARTF_USEPOSITION;

	PROCESS_INFORMATION processInformation;
	::ZeroMemory(&processInformation, sizeof(processInformation));

	if (!::CreateProcess(
		NULL,
		(char *)command.c_str(),
		NULL,
		NULL,
		TRUE,
		CREATE_NO_WINDOW,
		NULL,
		NULL,
		&startUpInfo,
		&processInformation))
	{
		return false;
	}

	// Close unused handles.
	::CloseHandle(hChildStdInWrite);
	::CloseHandle(hChildStdInRead);
	::CloseHandle(hChildStdOutWrite);

	char buffer[2048];
	char *bufferPosition = buffer;
	size_t bufferLeft = sizeof(buffer) - 1;

	for (;;)
	{
	for (;;)
	{
		DWORD length;
		if (!::ReadFile(hChildStdOutRead, bufferPosition, bufferLeft, &length, NULL))
			break;

		if (!length)
			break;

		bufferPosition += length;
		bufferLeft -= length;
		if (!bufferLeft)
			break;
	}
	*bufferPosition = '\0';

	// Wait for the process to exit...
	if (::WaitForSingleObject(processInformation.hProcess, 100) == WAIT_TIMEOUT)
		continue;
	break;
	}

	::CloseHandle(processInformation.hProcess);
	::CloseHandle(processInformation.hThread);

	// From robocopy's output derive the state of the file copy operation.
	if (const char *f = ::strstr(buffer, "Files :"))
	{
		if (f = ::strstr(f+7, "Files :"))
		{
			int r0 = atoi(f+7);
			if (r0 != 1)
			{
				CConnectionManager::Instance().Log(this, buffer);
				return false;
			}
		}
	}

	return true;

#elif defined(USE_SHELLCOPY)

	string destination = remoteDestination;
	::replace_chars(destination, '/', '\\');

	string s;

	size_t offset = 0;
	while (true)
	{
		s = destination;
		size_t length = Path::GetDirectoryLength(&s[offset]);
		if (!length)
			break;

		offset += length;
		s.clear();
		s.append(destination.c_str(), offset);
		DirectoryCreate(s.c_str());
	}

	char source[MAX_PATH];
	::strcpy(source, localSource);
	source[::strlen(source)+1] = '\0';

	char dest[MAX_PATH];
	::strcpy(dest, remoteDestination);
	dest[::strlen(dest)+1] = '\0';

	SHFILEOPSTRUCT shFileOp;
	shFileOp.hwnd = NULL;
	shFileOp.wFunc = FO_COPY;
	shFileOp.pFrom = source;
	shFileOp.pTo = dest;
	shFileOp.fFlags = FOF_FILESONLY | FOF_NOCONFIRMATION | FOF_NOCONFIRMMKDIR | FOF_SILENT | FOF_NOERRORUI;
	if (int r = ::SHFileOperation(&shFileOp))
		return false;

#else

	string source = localSource;
	::replace_chars(source, '/', '\\');
	string destination = remoteDestination;
	::replace_chars(destination, '/', '\\');

	string s;

	size_t offset = 0;
	while (true)
	{
		s = destination;
		size_t length = Path::GetDirectoryLength(&s[offset]);
		if (!length)
			break;

		offset += length;
		s.clear();
		s.append(destination.c_str(), offset);
		DirectoryCreate(s.c_str());
	}

	if (!::CopyFileEx(
		source.c_str(), destination.c_str(), NULL, NULL, NULL,
		COPY_FILE_ALLOW_DECRYPTED_DESTINATION))
	{
		::SetFileAttributes(destination.c_str(), FILE_ATTRIBUTE_NORMAL);
		if (!::CopyFileEx(
			source.c_str(), destination.c_str(), NULL, NULL, NULL,
			COPY_FILE_ALLOW_DECRYPTED_DESTINATION))
		{
			if (!::CopyFileEx(
				source.c_str(), destination.c_str(), NULL, NULL, NULL,
				COPY_FILE_ALLOW_DECRYPTED_DESTINATION | COPY_FILE_RESTARTABLE))
			{
				if (bSilent)
					return false;

				DWORD lastError = ::GetLastError();
				char message[2048];
				message[0] = '$';
				message[1] = '4';
				::FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, (LPCVOID)lastError,
					lastError, NULL, &message[2], sizeof(message)-2, NULL);
				CConnectionManager::Instance().Log(this, message);
				return false;
			}
		}
	}

#endif

	return true;
}

bool CConnectionLocal::FileCopyFrom(const char *remoteSource, const char *localDestination, bool bSilent)
{
	return FileCopyTo(remoteSource, localDestination, bSilent);
}

bool CConnectionLocal::FileDelete(const char *remotePath)
{
	return false;
}

bool CConnectionLocal::FileList(const char *remotePath, std::vector<string> &files)
{
	string s = remotePath;
	::append_if_not_last(s, '/', "/\\");
	s += "*.*";

	WIN32_FIND_DATA findData;
	HANDLE hR = ::FindFirstFile(s.c_str(), &findData);
	while (true)
	{
		if ((findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != FILE_ATTRIBUTE_DIRECTORY)
		{
			files.push_back(findData.cFileName);
		}

		if (!::FindNextFile(hR, &findData))
			break;
	}
	if (hR)
		::FindClose(hR);

	return true;
}

bool CConnectionLocal::FileSetLastChangeTime(const char *remotePath, const SFileTime &fileTime)
{
	return false;
	SYSTEMTIME systemTime;
	systemTime.wYear = fileTime.year;
	systemTime.wMonth = fileTime.month;
	systemTime.wDay = fileTime.day;
	systemTime.wHour = fileTime.hour;
	systemTime.wMinute = fileTime.minute;
	systemTime.wSecond = fileTime.second;
	systemTime.wMilliseconds = fileTime.milliseconds;

	WIN32_FILE_ATTRIBUTE_DATA fileAttributeData;
	HANDLE hFile;
	if (!::SetFileTime(hFile,
		&fileAttributeData.ftCreationTime,
		&fileAttributeData.ftLastAccessTime,
		&fileAttributeData.ftLastWriteTime))
	{
		return false;
	}

	return false;
}

bool CConnectionLocal::FileGetLastChangeTime(const char *remotePath, SFileTime &fileTime)
{
	WIN32_FILE_ATTRIBUTE_DATA fileAttributeData;
	if (!::GetFileAttributesEx(remotePath, GetFileExInfoStandard, &fileAttributeData))
		return false;

	SYSTEMTIME systemTime;
	if (!::FileTimeToSystemTime(&fileAttributeData.ftLastWriteTime, &systemTime))
		return false;

	fileTime.year = systemTime.wYear;
	fileTime.month = systemTime.wMonth;
	fileTime.day = systemTime.wDay;
	fileTime.hour = systemTime.wHour;
	fileTime.minute = systemTime.wMinute;
	fileTime.second = systemTime.wSecond;
	fileTime.milliseconds = systemTime.wMilliseconds;
	return true;
}

bool CConnectionLocal::DirectoryCreate(const char *remotePath)
{
	if (!::CreateDirectory(remotePath, NULL))
		return false;

	return false;
}

bool CConnectionLocal::DirectoryDelete(const char *remotePath)
{
	return false;
}

bool CConnectionLocal::Launch(const char *localBuildsPath, const char *remotePath, const char *projectDirectory, const char *application, const char *level)
{
	string s = remotePath;
	string command("");
	::append_if_not_last(s, '/', "/\\");
	s += application;

	if ( level )
	{
		command = "+map ";
		command += level;
	}

	::ShellExecute(NULL, "open", s.c_str(), command.c_str(), NULL, SW_SHOWNA);
	return false;
}

void CConnectionLocal::CleanBuild(const string &targetdir)
{
	CConnectionManager::Instance().Log(this, "Backing up build folder before clean, this may take some time..");
	FolderParseUtil::Instance().BackupFolder(targetdir);
	CConnectionManager::Instance().Log(this, "Finished backing up build folder.");
	CConnectionManager::Instance().Log(this, "Cleaning unwanted folder:");
	
	std::vector<string> folderFound;
	if ( !FolderParseUtil::Instance().ScanDirectory(targetdir,folderFound,false) )
		return;

	for( std::vector<string>::iterator item = folderFound.begin(), end = folderFound.end(); item != end; item++ )
	{
		if ( FolderParseUtil::Instance().CleanFolder((*item)) )
		{
			string message = "Removing folder: '" + (*item) + "'...";
			CConnectionManager::Instance().Log(this, message.c_str());
			FolderParseUtil::Instance().RemoveDirectory((*item).c_str());
		}
	}

	CConnectionManager::Instance().Log(this, "Build Destination has been cleaned.");
}
