#pragma once

#include "ConnectionManager.h"

namespace RemoteControl {

class CConnectionLocal :
	public CConnection
{
public:
	static bool RefreshConnections();

private:
	CConnectionLocal();
	~CConnectionLocal();

	// IConnection
public:
	virtual void Release() { } // This class is as singleton.

	virtual const char *GetType() { return "PC"; }
	virtual const char *GetName() { return "Local"; }

	virtual bool Open() { return true; }
	virtual void Close() { }

	virtual bool SendCommand(const char *command, char *response, size_t &length);

	virtual bool DirectoryCreate(const char *remotePath);
	virtual bool DirectoryDelete(const char *remotePath);
	virtual bool DirectoryList(const char *remotePath, std::vector<string> &directories);

	virtual bool FileCopyTo(const char *localSource, const char *remoteDestination, bool bSilent);
	virtual bool FileCopyFrom(const char *remoteSource, const char *localDestination, bool bSilent);
	virtual bool FileDelete(const char *remotePath);
	virtual bool FileList(const char *remotePath, std::vector<string> &files);

	virtual bool FileSetLastChangeTime(const char *remotePath, const SFileTime &fileTime);
	virtual bool FileGetLastChangeTime(const char *remotePath, SFileTime &fileTime);

	virtual bool Launch(const char *localBuildsPath, const char *remotePath, const char *projectDirectory, const char *application, const char *level);

	virtual void CleanBuild(const string &targetdir);

	virtual bool IsLocalTargetBuild() { return true; }
	virtual bool IsTargetConnected() { return true; }

};

} // namespace RemoteControl
