#include "stdafx.h"
#include "ConnectionManager.h"

using namespace RemoteControl;

/*

  CConnection

*/

CConnection::CConnection()
{
	m_pCNNClient = NULL;
}

CConnection::~CConnection()
{
}

//

bool CConnection::CNNSend(const char *channel, const void *pBuffer, size_t length)
{
	for (unsigned int i=0; i<10; ++i)
	{
		if (!m_pCNNClient)
		{
			m_pCNNClient = CCryNotificationNetworkClient::Create(m_cnnAddress.c_str());
			if (!m_pCNNClient)
				continue;
		}

		if (m_pCNNClient->Send(channel, pBuffer, length))
			return true;

		m_pCNNClient->Release();
		m_pCNNClient = NULL;
	}

	return false;
}

// IConnection

bool CConnection::SendCommand(const char *command)
{
	return CNNSend("Command", command, ::strlen(command)+1);
}

/*

  CConnectionManager

*/

CConnectionManager &CConnectionManager::Instance()
{
	static CConnectionManager instance;
	return instance;
}

//

CConnectionManager::CConnectionManager()
{
	m_connectionLast = -1;

	m_pCallback = NULL;
}

CConnectionManager::~CConnectionManager()
{
}

void CConnectionManager::ReleaseConnections()
{
	for (size_t i=0; i<m_connections.size(); ++i)
	{
		m_connections[i]->Release();
		m_connections[i] = NULL;
	}
	m_connections.clear();
}

//

bool CConnectionManager::Initialize()
{
	typedef bool *(*FInitialize)(void);
	CConnectionDesc *pDesc = CConnectionDesc::pDescs;
	while (pDesc)
	{
		if (pDesc->pInitialize)
			((FInitialize)pDesc->pInitialize)();
		pDesc = pDesc->pNext;
	}

	return false;
}

void CConnectionManager::Shutdown()
{
	typedef bool *(*FShutdown)(void);
	CConnectionDesc *pDesc = CConnectionDesc::pDescs;
	while (pDesc)
	{
		if (pDesc->pShutdown)
			((FShutdown)pDesc->pShutdown)();
		pDesc = pDesc->pNext;
	}
	ReleaseConnections();
}

//

void CConnectionManager::RefreshConnections()
{
	ReleaseConnections();
	typedef bool *(*FRefresh)(void);
	CConnectionDesc *pDesc = CConnectionDesc::pDescs;
	while (pDesc)
	{
		if (pDesc->pRefresh)
			((FRefresh)pDesc->pRefresh)();

		pDesc = pDesc->pNext;
	}
}

IConnection *CConnectionManager::OpenConnection(size_t index)
{
	if (m_connections.size() <= index)
		return NULL;

	if (m_connectionLast != -1)
		m_connections[m_connectionLast]->Close();
	m_connectionLast = -1;

	// local target builds ie pc and ps3 should be allowed to copy the build to the local repository 
	// even if the target is not connection
	if (!m_connections[index]->Open() && !m_connections[index]->IsLocalTargetBuild() )
		return NULL;

	return m_connections[index];
}

void CConnectionManager::Log(IConnection *pConnection, const char *text)
{
	if (!m_pCallback)
		return;

	m_pCallback->OnConnectionManagerLog(text);
}

/*

  CConnectionDesc

*/

CConnectionDesc *CConnectionDesc::pDescs = NULL;

//

CConnectionDesc::CConnectionDesc(void *pInitialize, void *pShutdown, void *pRefresh) :
	pInitialize(pInitialize),
	pShutdown(pShutdown),
	pRefresh(pRefresh)
{
	pNext = pDescs;
	pDescs = this;
}
