#include "stdafx.h"
#include "ConnectionPS3.h"
#include "FileUtil.h"

#include <iostream>
#include <fstream>

#define PS3_COPY_TO_PC 1
#define OVERRIDE_SYSTEM_CFG 0
#define MINIMUM_CONNECTION_TIMEOUT 200
#define DEFAULT_CONNECTION_TIMEOUT 6000

using namespace RemoteControl;

#pragma comment(lib, "ps3tmapi.lib")

/*

  CConnectionPS3

*/

ConnectionRegister(PS3,
	&CConnectionPS3::Initialize,
	&CConnectionPS3::Shutdown,
	&CConnectionPS3::RefreshConnections);

//

SNPS3TMDynamicAPI *CConnectionPS3::s_pSNP3 = NULL;
HANDLE CConnectionPS3::s_hSNPS3Thread = NULL;
LONG CConnectionPS3::s_bSNPS3ThreadExecute = true;
LONG CConnectionPS3::s_bSNPS3ThreadRefreshConnections = false;
CConnectionPS3 *CConnectionPS3::s_pSNPS3ThreadConnection = NULL;
void **CConnectionPS3::s_pSNPS3ThreadParameters = NULL;
void *CConnectionPS3::s_pSNPS3ThreadReturn = NULL;
SNRESULT CConnectionPS3::s_snResult = 0;

HANDLE CConnectionPS3::s_hSNPS3EventExecuteBegin = NULL;
HANDLE CConnectionPS3::s_hSNPS3EventExecuteEnd = NULL;
HANDLE CConnectionPS3::s_hSNPS3EventFTP = NULL;


//

bool CConnectionPS3::Initialize()
{
	s_pSNP3 = SNPS3TMDynamicAPI::Create();
	if (!s_pSNP3)
	{
		Shutdown();
		return false;
	}

	s_hSNPS3EventExecuteBegin = ::CreateEvent(NULL, TRUE, FALSE, NULL);
	s_hSNPS3EventExecuteEnd = ::CreateEvent(NULL, TRUE, FALSE, NULL);
	s_hSNPS3EventFTP = ::CreateEvent(NULL, TRUE, FALSE, NULL);
	if (!s_hSNPS3EventExecuteBegin ||
		!s_hSNPS3EventExecuteEnd ||
		!s_hSNPS3EventFTP)
	{
		Shutdown();
		return false;
	}

	s_hSNPS3Thread = ::CreateThread(
		NULL, NULL, (LPTHREAD_START_ROUTINE)SNPS3Thread, NULL, NULL, NULL);
	if (!s_hSNPS3Thread)
	{
		Shutdown();
		return false;
	}

	RefreshConnections();

	return true;
}

void CConnectionPS3::Shutdown()
{
	s_bSNPS3ThreadExecute = false;
	::ResetEvent(s_hSNPS3EventExecuteEnd);
	::SetEvent(s_hSNPS3EventExecuteBegin);
	::WaitForSingleObject(s_hSNPS3EventExecuteEnd, INFINITE);

	if (s_hSNPS3Thread)
		::CloseHandle(s_hSNPS3Thread);

	if (s_hSNPS3EventExecuteEnd)
		::CloseHandle(s_hSNPS3EventExecuteEnd);

	if (s_hSNPS3EventExecuteBegin)
		::CloseHandle(s_hSNPS3EventExecuteBegin);

	if (s_pSNP3)
		s_pSNP3->Release();

}

//

void CConnectionPS3::ExecuteRefreshConnections()
{
	s_pSNP3->EnumerateTargetsEx(SNPS3EnumerateTargetsCallback,
		&CConnectionManager::Instance());
}

bool CConnectionPS3::RefreshConnections()
{
//	CConnectionManager::Instance().Log(NULL, "Refreshing PS3 Connections.");
	s_bSNPS3ThreadRefreshConnections = true;
	::ResetEvent(s_hSNPS3EventExecuteEnd);
	::SetEvent(s_hSNPS3EventExecuteBegin);
	::WaitForSingleObject(s_hSNPS3EventExecuteEnd, INFINITE);

	return true;
}

//

int CConnectionPS3::SNPS3Thread(void *pParameter)
{
	if (SN_FAILED(s_pSNP3->InitTargetComms()))
		return 0;

	for (;;)
	{
		while (::WaitForSingleObject(s_hSNPS3EventExecuteBegin, 10) == WAIT_TIMEOUT)
		{
			s_pSNP3->Kick();
		}

		::ResetEvent(s_hSNPS3EventExecuteBegin);

		if (!s_bSNPS3ThreadExecute)
			break;

		if (s_bSNPS3ThreadRefreshConnections)
		{
			ExecuteRefreshConnections();
			s_bSNPS3ThreadRefreshConnections = false;
		}
		else if (s_pSNPS3ThreadConnection)
		{
			s_pSNPS3ThreadConnection->SNPS3ThreadExecute();
			s_pSNPS3ThreadConnection = NULL;
		}

		// NOTE: Calling Kick() here will eventually make the application hang.
//		s_pSNP3->Kick();

		::SetEvent(s_hSNPS3EventExecuteEnd);
	}

	s_pSNP3->CloseTargetComms();

	::SetEvent(s_hSNPS3EventExecuteEnd);
	return 0;
}

// Callbacks

int __stdcall CConnectionPS3::SNPS3EnumerateTargetsCallback(HTARGET hTarget, void *pUser)
{
	SNPS3_TM_TIMEOUT timeoutIDs[1];
	UINT32 timeouts[1];
	timeoutIDs[0] = CONNECT_TIMEOUT;
	timeouts[0] = MINIMUM_CONNECTION_TIMEOUT;

	s_pSNP3->SetTimeouts(hTarget,1,&timeoutIDs[0],&timeouts[0]);

	long powerStatus;
	ECONNECTSTATUS uConnectStatus;
	char * buffer;
	SNRESULT result = s_pSNP3->GetConnectionStatus(hTarget,&uConnectStatus,&buffer);
	if ( !SN_FAILED(result) && uConnectStatus != ECONNECTSTATUS::CS_CONNECTED )
	{
		s_pSNP3->Connect(hTarget, NULL);
		s_pSNP3->GetPowerStatus(hTarget, &powerStatus);
		s_pSNP3->Disconnect(hTarget);
	}

	SNPS3TargetInfo targetInfo;	
	targetInfo.hTarget = hTarget;
	targetInfo.nFlags = SN_TI_TARGETID;
	s_pSNP3->GetTargetInfo(&targetInfo);
	CConnectionPS3 *pConnection = new CConnectionPS3(targetInfo);
	CConnectionManager::Instance().AddConnection(pConnection);

	timeouts[0] = DEFAULT_CONNECTION_TIMEOUT;
	s_pSNP3->SetTimeouts(hTarget,1,&timeoutIDs[0],&timeouts[0]);
	return 0;
}

void __stdcall CConnectionPS3::SNPS3TTYEventAllStreamsCallback(HTARGET hTarget, UINT eventType, UINT parameter, SNRESULT snResult, UINT length, BYTE *pData, void *pUser)
{
	if (eventType != SN_EVENT_TTY)
		return;

	string s;
	s.append((const char *)pData, length);
	CConnectionManager::Instance().Log((CConnectionPS3 *)pUser, s.c_str());
}

void __stdcall CConnectionPS3::SNPS3FTPEvenCallback(HTARGET hTarget, UINT eventType, UINT parameter, SNRESULT snResult, UINT length, BYTE *pData, void *pUser)
{
	CConnectionPS3 *pConnection = (CConnectionPS3 *)pUser;
	TMAPI_FT_NOTIFICATION *pNotifications = (TMAPI_FT_NOTIFICATION *)pData;

	::EnterCriticalSection(&pConnection->m_snps3FTPCurrentIDCritialSection);
	bool bReturn =  pConnection->m_snps3FTPCurrentID != pNotifications->m_TransferID;
	if (!bReturn)
		pConnection->m_snps3FTPEventLastTime = ::GetTickCount();
	::LeaveCriticalSection(&pConnection->m_snps3FTPCurrentIDCritialSection);

	if (bReturn)
		return;

	UINT count = length/sizeof(TMAPI_FT_NOTIFICATION);
	UINT i;
	for (i=0; i<count; ++i)
	{
		if (pNotifications[i].m_Type == TMAPI_FT_FINISH || 
			pNotifications[i].m_Type == TMAPI_FT_SKIPPED || 
			pNotifications[i].m_Type == TMAPI_FT_ERROR)
		{
			break;
		}
	}
	if (i == count)
		return;

	pConnection->m_bSNPS3FTPEventResult = snResult;

	if (pNotifications[i].m_Type == TMAPI_FT_ERROR)
		pConnection->m_bSNPS3FTPEventResult = -1;

	::SetEvent(s_hSNPS3EventFTP);
}

//

CConnectionPS3::CConnectionPS3(const SNPS3TargetInfo &targetInfo)
{
	m_targetInfo = targetInfo;

	m_targetInfo.pszName = new char[128];
	::strcpy_s((char *)m_targetInfo.pszName, 128, targetInfo.pszName);

	m_targetInfo.pszType = new char[128];
	::strcpy_s((char *)m_targetInfo.pszType, 128, targetInfo.pszType);

	m_targetInfo.pszInfo = new char[128];
	::strcpy_s((char *)m_targetInfo.pszInfo, 128, targetInfo.pszInfo);

	m_bConnected = false;

	m_snps3ThreadFunc = NULL;

	m_snps3FTPCurrentID = NULL;
	::InitializeCriticalSection(&m_snps3FTPCurrentIDCritialSection);
}

CConnectionPS3::~CConnectionPS3()
{
	DeleteCriticalSection(&m_snps3FTPCurrentIDCritialSection);

	Close();

	delete[] m_targetInfo.pszInfo;
	delete[] m_targetInfo.pszType;
	delete[] m_targetInfo.pszName;
}

//

void CConnectionPS3::SNPS3ThreadExecute()
{
	if (m_snps3ThreadFunc)
		(*this.*m_snps3ThreadFunc)();
}

// IConnection

const char *CConnectionPS3::GetName()
{
	return m_targetInfo.pszName;
}

void CConnectionPS3::ExecuteOpen()
{
	SNPS3_TM_TIMEOUT timeoutIDs[1];
	UINT32 timeouts[1];
	timeoutIDs[0] = CONNECT_TIMEOUT;
	timeouts[0] = MINIMUM_CONNECTION_TIMEOUT;

	s_pSNP3->SetTimeouts(m_targetInfo.hTarget,1,&timeoutIDs[0],&timeouts[0]);

	SNRESULT snResult = s_pSNP3->Connect(m_targetInfo.hTarget, NULL);

	timeouts[0] = DEFAULT_CONNECTION_TIMEOUT;
	s_pSNP3->SetTimeouts(m_targetInfo.hTarget,1,&timeoutIDs[0],&timeouts[0]);

	if (SN_FAILED(snResult))
	{
		s_snResult = snResult;
		*(bool *)s_pSNPS3ThreadReturn = false;
		return;
	}
	
	m_bConnected = true;

	snResult = s_pSNP3->RegisterTTYEventHandler(
		m_targetInfo.hTarget, SNPS3_TTY_ALL_STREAMS, SNPS3TTYEventAllStreamsCallback, this);
	if (SN_FAILED(snResult))
	{
		ExecuteClose();
		*(bool *)s_pSNPS3ThreadReturn = false;
		s_snResult = snResult;
		return;
	}

	SNPS3GamePortIPAddressData snps3GamePortIPAddressData;
	snResult = s_pSNP3->GetGamePortIPAddrData(
		m_targetInfo.hTarget, "eth0", &snps3GamePortIPAddressData);
	{
		static char ip[16];
		sprintf_s(ip, 16, "%d.%d.%d.%d", 
			((unsigned char *)&snps3GamePortIPAddressData.uIPAddress)[3],
			((unsigned char *)&snps3GamePortIPAddressData.uIPAddress)[2],
			((unsigned char *)&snps3GamePortIPAddressData.uIPAddress)[1],
			((unsigned char *)&snps3GamePortIPAddressData.uIPAddress)[0]);
		SetCNNAddress(ip);
	}

	snResult = s_pSNP3->RegisterFTPEventHandler(
		m_targetInfo.hTarget, SNPS3FTPEvenCallback, this);
	if (SN_FAILED(snResult))
	{
		ExecuteClose();
		*(bool *)s_pSNPS3ThreadReturn = false;
		s_snResult = snResult;
		return;
	}
		
	*(bool *)s_pSNPS3ThreadReturn = true;
}

bool CConnectionPS3::Open()
{
	bool bReturn;
	m_bConnected = false;
	s_snResult = 0;
	s_pSNPS3ThreadReturn = &bReturn;
	m_snps3ThreadFunc = &CConnectionPS3::ExecuteOpen;
	s_pSNPS3ThreadConnection = this;
	::ResetEvent(s_hSNPS3EventExecuteEnd);
	::SetEvent(s_hSNPS3EventExecuteBegin);
	::WaitForSingleObject(s_hSNPS3EventExecuteEnd, INFINITE);

	
	if ( SN_FAILED(s_snResult) )
	{
		switch (s_snResult)
		{
			case SN_E_TIMEOUT :	CConnectionManager::Instance().Log(this, "Connection timeout.");
				break;
			case SN_E_COMMS_ERR : CConnectionManager::Instance().Log(this, "Communication error.");
				break;
			case SN_E_TARGET_IN_USE : CConnectionManager::Instance().Log(this, "Target in use.");
				break;
			default : CConnectionManager::Instance().Log(this, "Connection error.");
		}
	}
	
	return bReturn;
}

void CConnectionPS3::ExecuteClose()
{
	if (!m_bConnected)
		return;

	s_pSNP3->CancelFTPEvents(m_targetInfo.hTarget);
	s_pSNP3->CancelTTYEvents(m_targetInfo.hTarget, SNPS3_TTY_ALL_STREAMS);

	s_pSNP3->Disconnect(m_targetInfo.hTarget);
	m_bConnected = false;
}

void CConnectionPS3::Close()
{
	m_snps3ThreadFunc = &CConnectionPS3::ExecuteClose;
	s_pSNPS3ThreadConnection = this;
	::ResetEvent(s_hSNPS3EventExecuteEnd);
	::SetEvent(s_hSNPS3EventExecuteBegin);
	::WaitForSingleObject(s_hSNPS3EventExecuteEnd, INFINITE);
}

bool CConnectionPS3::SendCommand(const char *command, char *response, size_t &length)
{
	CConnection::SendCommand(command);
	length = 0;
	return false;
}

bool CConnectionPS3::PathList(const char *remotePath, bool bFiles, std::vector<string> &result)
{
	static const unsigned int ENTRY_CAPACITY = 128;

	SNPS3DirEntry dirEntries[ENTRY_CAPACITY];
	unsigned int entryCount = ENTRY_CAPACITY;
	SNRESULT snResult = s_pSNP3->GetDirectoryList(
		m_targetInfo.hTarget, remotePath, &entryCount, dirEntries);
	if (SN_FAILED(snResult))
		return false;

	for (unsigned int i=0; i<entryCount; ++i)
	{
		if (dirEntries[i].Type == SNPS3_DIRENT_TYPE_DIRECTORY)
		{
			if (bFiles)
				continue;
		}
		else
		{
			if (!bFiles)
				continue;
		}

		result.push_back(dirEntries[i].Name);
	}

	return true;
}

void CConnectionPS3::ExecuteDirectoryList()
{
	const char *remotePath = (const char *)s_pSNPS3ThreadParameters[0];
	std::vector<string> &directories = *(std::vector<string> *)s_pSNPS3ThreadParameters[1];

	*(bool *)s_pSNPS3ThreadReturn = PathList(remotePath, false, directories);
}

bool CConnectionPS3::DirectoryList(const char *remotePath, std::vector<string> &directories)
{
#if PS3_COPY_TO_PC
	return GetPCConnection()->DirectoryList(remotePath,directories);
#else
	void *parameters[] =
	{
		(void *)remotePath,
		&directories,
	};
	s_pSNPS3ThreadParameters = parameters;

	bool bReturn;
	s_pSNPS3ThreadReturn = &bReturn;

	m_snps3ThreadFunc = &CConnectionPS3::ExecuteDirectoryList;
	s_pSNPS3ThreadConnection = this;
	::ResetEvent(s_hSNPS3EventExecuteEnd);
	::SetEvent(s_hSNPS3EventExecuteBegin);
	::WaitForSingleObject(s_hSNPS3EventExecuteEnd, INFINITE);

	return bReturn;
#endif
}

void CConnectionPS3::ExecuteFileList()
{
	const char *remotePath = (const char *)s_pSNPS3ThreadParameters[0];
	std::vector<string> &files = *(std::vector<string> *)s_pSNPS3ThreadParameters[1];

	*(bool *)s_pSNPS3ThreadReturn = PathList(remotePath, true, files);
}

bool CConnectionPS3::FileList(const char *remotePath, std::vector<string> &files)
{
#if PS3_COPY_TO_PC
	return GetPCConnection()->FileList(remotePath, files);
#else
	void *parameters[] =
	{
		(void *)remotePath,
		&files,
	};
	s_pSNPS3ThreadParameters = parameters;

	bool bReturn = false;
	s_pSNPS3ThreadReturn = &bReturn;

	m_snps3ThreadFunc = &CConnectionPS3::ExecuteFileList;
	s_pSNPS3ThreadConnection = this;
	::ResetEvent(s_hSNPS3EventExecuteEnd);
	::SetEvent(s_hSNPS3EventExecuteBegin);
	::WaitForSingleObject(s_hSNPS3EventExecuteEnd, INFINITE);

	return bReturn;
#endif
}

void CConnectionPS3::ExecuteFileCopyTo()
{
	const char *localSource = (const char *)s_pSNPS3ThreadParameters[0];
	const char *remoteDestination = (const char *)s_pSNPS3ThreadParameters[1];

	string destination = remoteDestination;
	::replace_chars(destination, '\\', '/');

	string s;

	size_t offset = 0;
	while (true)
	{
		s = destination;
		size_t length = Path::GetDirectoryLength(&s[offset]);
		if (!length)
			break;

		offset += length;
		s.clear();
		s.append(destination.c_str(), offset);
		s_pSNP3->MakeDirectory(m_targetInfo.hTarget, s.c_str(), NULL);
	}

	::ResetEvent(s_hSNPS3EventFTP);

	::EnterCriticalSection(&m_snps3FTPCurrentIDCritialSection);
	SNRESULT snResult = s_pSNP3->UploadFile(m_targetInfo.hTarget, localSource, destination.c_str(), &m_snps3FTPCurrentID);
	::LeaveCriticalSection(&m_snps3FTPCurrentIDCritialSection);
	if (SN_FAILED(snResult))
	{
		*(bool *)s_pSNPS3ThreadReturn = false;
		return;
	}

	s_pSNP3->Kick();

	while (::WaitForSingleObject(s_hSNPS3EventFTP, 10) == WAIT_TIMEOUT)
	{
		s_pSNP3->Kick();
	}

	if (SN_FAILED(m_bSNPS3FTPEventResult))
	{
		*(bool *)s_pSNPS3ThreadReturn = false;
		return;
	}

	*(bool *)s_pSNPS3ThreadReturn = true;
}

bool CConnectionPS3::FileCopyTo(const char *localSource, const char *remoteDestination, bool bSilent)
{
#if PS3_COPY_TO_PC
	return GetPCConnection()->FileCopyTo(localSource, remoteDestination, bSilent);
#else
	void *parameters[] =
	{
		(void *)localSource,
		(void *)remoteDestination,
	};
	s_pSNPS3ThreadParameters = parameters;

	bool bReturn;
	s_pSNPS3ThreadReturn = &bReturn;

	m_snps3FTPEventLastTime = ::GetTickCount();

	m_snps3ThreadFunc = &CConnectionPS3::ExecuteFileCopyTo;
	s_pSNPS3ThreadConnection = this;
	::ResetEvent(s_hSNPS3EventExecuteEnd);
	::SetEvent(s_hSNPS3EventExecuteBegin);
	while (::WaitForSingleObject(s_hSNPS3EventExecuteEnd, 1000) == WAIT_TIMEOUT)
	{
		::EnterCriticalSection(&m_snps3FTPCurrentIDCritialSection);
		bool bBreak = ::GetTickCount() - m_snps3FTPEventLastTime > 5000;
		::LeaveCriticalSection(&m_snps3FTPCurrentIDCritialSection);
		if (bBreak)
			return false;
	}

	return bReturn;
#endif
}

void CConnectionPS3::ExecuteFileCopyFrom()
{
	const char *remoteSource = (const char *)s_pSNPS3ThreadParameters[0];
	const char *localDestination = (const char *)s_pSNPS3ThreadParameters[1];

	::ResetEvent(s_hSNPS3EventFTP);

	string s = remoteSource;
	::replace_chars(s, '\\', '/');
	::EnterCriticalSection(&m_snps3FTPCurrentIDCritialSection);
	SNRESULT snResult = s_pSNP3->DownloadFile(
		m_targetInfo.hTarget, s.c_str(), localDestination, &m_snps3FTPCurrentID);
	::LeaveCriticalSection(&m_snps3FTPCurrentIDCritialSection);
	if (SN_FAILED(snResult))
	{
		*(bool *)s_pSNPS3ThreadReturn = false;
		return;
	}

	s_pSNP3->Kick();

	while (::WaitForSingleObject(s_hSNPS3EventFTP, 10) == WAIT_TIMEOUT)
	{
		s_pSNP3->Kick();
	}

	if (SN_FAILED(m_bSNPS3FTPEventResult))
	{
		*(bool *)s_pSNPS3ThreadReturn = false;
		return;
	}

	*(bool *)s_pSNPS3ThreadReturn = true;
}

bool CConnectionPS3::FileCopyFrom(const char *remoteSource, const char *localDestination, bool bSilent)
{
#if PS3_COPY_TO_PC
	return GetPCConnection()->FileCopyFrom(remoteSource, localDestination, bSilent);
#else
	void *parameters[] =
	{
		(void *)remoteSource,
		(void *)localDestination,
	};
	s_pSNPS3ThreadParameters = parameters;

	bool bReturn;
	s_pSNPS3ThreadReturn = &bReturn;

	m_snps3FTPEventLastTime = ::GetTickCount();

	m_snps3ThreadFunc = &CConnectionPS3::ExecuteFileCopyFrom;
	s_pSNPS3ThreadConnection = this;
	::ResetEvent(s_hSNPS3EventExecuteEnd);
	::SetEvent(s_hSNPS3EventExecuteBegin);
	while (::WaitForSingleObject(s_hSNPS3EventExecuteEnd, 1000) == WAIT_TIMEOUT)
	{
		::EnterCriticalSection(&m_snps3FTPCurrentIDCritialSection);
		bool bBreak = ::GetTickCount() - m_snps3FTPEventLastTime > 1000;
		::LeaveCriticalSection(&m_snps3FTPCurrentIDCritialSection);
		if (bBreak)
			return false;
	}

	return bReturn;
#endif
}

void CConnectionPS3::ExecuteFileDelete()
{
	const char *remotePath = (const char *)s_pSNPS3ThreadParameters[0];

	SNRESULT snResult = s_pSNP3->Delete(m_targetInfo.hTarget, remotePath);

	if (SN_FAILED(snResult))
	{
		*(bool *)s_pSNPS3ThreadReturn = false;
		return;
	}

	*(bool *)s_pSNPS3ThreadReturn = true;
}

bool CConnectionPS3::FileDelete(const char *remotePath)
{
	void *parameters[] =
	{
		(void *)remotePath,
	};
	s_pSNPS3ThreadParameters = parameters;

	bool bReturn;
	s_pSNPS3ThreadReturn = &bReturn;

	m_snps3ThreadFunc = &CConnectionPS3::ExecuteFileDelete;
	s_pSNPS3ThreadConnection = this;
	::ResetEvent(s_hSNPS3EventExecuteEnd);
	::SetEvent(s_hSNPS3EventExecuteBegin);
	::WaitForSingleObject(s_hSNPS3EventExecuteEnd, INFINITE);

	return bReturn;
}

void CConnectionPS3::ExecuteLaunch()
{
	string &m_path = *(string *)s_pSNPS3ThreadParameters[0];
	string &m_appHome = *(string *)s_pSNPS3ThreadParameters[1];

	static char cDrive[] = "C:/";
	//m_targetInfo.pszHomeDir = m_appHome.c_str();
	m_targetInfo.pszFSDir = m_appHome.c_str();
	m_targetInfo.nFlags = SN_TI_FILESERVEDIR /*| SN_TI_HOMEDIR*/ | SN_TI_TARGETID;

	SNRESULT snResult = s_pSNP3->SetTargetInfo(&m_targetInfo);
	if (SN_FAILED(snResult))
	{
		*(bool *)s_pSNPS3ThreadReturn = false;
		return;
	}

	snResult = s_pSNP3->ProcessLoad(
		m_targetInfo.hTarget,
		SNPS3_DEF_PROCESS_PRI,
		m_path.c_str(),
		0, NULL,
		0, NULL,
		NULL,
		NULL,
		/*SNPS3_LOAD_FLAG_*/ 0);

	if (SN_FAILED(snResult))
	{
		*(bool *)s_pSNPS3ThreadReturn = false;
		return;
	}

	*(bool *)s_pSNPS3ThreadReturn = true;
}

bool CConnectionPS3::FileGetLastChangeTime(const char *remotePath, SFileTime &fileTime)
{
	WIN32_FILE_ATTRIBUTE_DATA fileAttributeData;
	if (!::GetFileAttributesEx(remotePath, GetFileExInfoStandard, &fileAttributeData))
		return false;

	SYSTEMTIME systemTime;
	if (!::FileTimeToSystemTime(&fileAttributeData.ftLastWriteTime, &systemTime))
		return false;

	fileTime.year = systemTime.wYear;
	fileTime.month = systemTime.wMonth;
	fileTime.day = systemTime.wDay;
	fileTime.hour = systemTime.wHour;
	fileTime.minute = systemTime.wMinute;
	fileTime.second = systemTime.wSecond;
	fileTime.milliseconds = systemTime.wMilliseconds;
	return true;
}

bool CConnectionPS3::Launch(const char *localBuildsPath, const char *remotePath, const char *projectDirectory, const char *application, const char *level)
{
#if OVERRIDE_SYSTEM_CFG
	static const char *ROOT_PATH = "/dev_hdd0/game/GAME02/USRDIR/";

	if (::strlen(remotePath) <= ::strlen(ROOT_PATH))
		return false;

	// Create system.cfg.
	std::ofstream file;
	::remove("C:/system.cfg");
	file.open("C:/system.cfg");
	if (!file.is_open())
		return false;

	string sys_game_folder = "sys_game_folder=";
	sys_game_folder += &remotePath[::strlen(ROOT_PATH)];
	::append_if_not_last(sys_game_folder, '/', "/\\");
	sys_game_folder += projectDirectory;
//	::_strlwr(&sys_game_folder[0]);

	file << sys_game_folder << '\n';

	if(level)
	{
		file << "autoload = " << level << '\n';
	}
//	file << "r_ShadersRemoteCompiler=1\n";
//	file << "r_shadersasynccompiling=0\n";
//	file << "r_ShaderCompilerServer=192.168.9.125\n";
	file.close();

	// Create launcher.cfg for backward compatibility with older builds.
	::remove("C:/launcher.cfg");
	file.open("C:/launcher.cfg");
	if (!file.is_open())
		return false;

	if(level)
	{
		file << "autoload = " << level << '\n';
	}
	file.close();

	// Remove the remote system.cfg in order to make sure the launcher will use
	// the local one.
	string s = remotePath;
	::append_if_not_last(s, '/', "/\\");
	s += "system.cfg";
	FileDelete(s.c_str());

	// Retrieve the remote buildversion file in order to know which local
	// application to launch.
	s = remotePath;
	::append_if_not_last(s, '/', "/\\");
	s += "buildversion";
	::remove("C:/buildversion");
	if (!FileCopyFrom(s.c_str(), "C:/buildversion", false))
		return false;

	std::ifstream inFile;
	inFile.open("C:/buildversion");
	if (!inFile.is_open())
		return false;

	char build[256];
	inFile.get(build, sizeof(build));
	inFile.close();
	::remove("C:/buildversion");

	// Compose the full local path to the application to remotely launch it.
	string path = localBuildsPath;
	::append_if_not_last(path, '/', "/\\");
	path += build;
	path += '/';
	path += application;
#else
	//don't want to pass pointers to stack variables
	static string path, appHome; 
	
	path.assign(application);
	appHome.assign(remotePath);
#endif

	// Reset before launching.
	if (!Reset())
		return false;

	void *parameters[] =
	{
		&path,
		&appHome
	};
	s_pSNPS3ThreadParameters = parameters;

	bool bReturn;
	s_pSNPS3ThreadReturn = &bReturn;

	m_snps3ThreadFunc = &CConnectionPS3::ExecuteLaunch;
	s_pSNPS3ThreadConnection = this;
	::ResetEvent(s_hSNPS3EventExecuteEnd);
	::SetEvent(s_hSNPS3EventExecuteBegin);
	::WaitForSingleObject(s_hSNPS3EventExecuteEnd, INFINITE);

	return bReturn;
}

void CConnectionPS3::CleanBuild(const string &targetdir)
{
	CConnectionManager::Instance().Log(this, "Cleaning unwanted folder:");
	std::vector<string> folderFound;
	if ( !FolderParseUtil::Instance().ScanDirectory(targetdir,folderFound,false) )
		return;

	for( std::vector<string>::iterator item = folderFound.begin(), end = folderFound.end(); item != end; item++ )
	{
		if ( !FolderParseUtil::Instance().IgnoreBinaryFileOrFolder((*item),false) )
		{
			string message = "Removing folder: '" + (*item) + "'...";
			CConnectionManager::Instance().Log(this, message.c_str());
			FolderParseUtil::Instance().RemoveDirectory((*item).c_str());
		}
	}

	CConnectionManager::Instance().Log(this, "Build Destination has been cleaned.");
}

void CConnectionPS3::ExecuteReset()
{
	SNRESULT snResult = s_pSNP3->Reset(m_targetInfo.hTarget, SNPS3TM_RESETP_SOFT_RESET);
	if (SN_FAILED(snResult))
	{
		*(bool *)s_pSNPS3ThreadReturn = false;
		return;
	}

	*(bool *)s_pSNPS3ThreadReturn = true;
}

bool CConnectionPS3::Reset()
{
	bool bReturn;
	s_pSNPS3ThreadReturn = &bReturn;

	m_snps3ThreadFunc = &CConnectionPS3::ExecuteReset;
	s_pSNPS3ThreadConnection = this;
	::ResetEvent(s_hSNPS3EventExecuteEnd);
	::SetEvent(s_hSNPS3EventExecuteBegin);
	::WaitForSingleObject(s_hSNPS3EventExecuteEnd, INFINITE);

	return bReturn;
}

void CConnectionPS3::ExecuteHasActiveProcesses()
{
	UINT buffer[16];
	UINT count = 16;
	SNRESULT snResult = s_pSNP3->ProcessList(m_targetInfo.hTarget, &count, buffer);
	if (SN_FAILED(snResult) || !count)
	{
		*(bool *)s_pSNPS3ThreadReturn = false;
		return;
	}

	*(bool *)s_pSNPS3ThreadReturn = true;
}

bool CConnectionPS3::HasActiveProcesses()
{
	bool bReturn;
	s_pSNPS3ThreadReturn = &bReturn;

	m_snps3ThreadFunc = &CConnectionPS3::ExecuteHasActiveProcesses;
	s_pSNPS3ThreadConnection = this;
	::ResetEvent(s_hSNPS3EventExecuteEnd);
	::SetEvent(s_hSNPS3EventExecuteBegin);
	::WaitForSingleObject(s_hSNPS3EventExecuteEnd, INFINITE);

	return bReturn;
}

IConnection* CConnectionPS3::GetPCConnection()
{
	size_t numConnections = CConnectionManager::Instance().GetConnectionCount();

	for(size_t i=0; i<numConnections; i++)
	{
		IConnection& connection = CConnectionManager::Instance().GetConnection(i);
		
		if( strcmp(connection.GetType(), "PC")==0 )
		{
			return &connection;
		}
	}
	//assert(0);
	return NULL;
}
