#pragma once

#include "SNPS3TMDynamicAPI.h"
#include "ConnectionManager.h"

namespace RemoteControl {

class CConnectionPS3 :
	public CConnection
{
private:
	typedef void (CConnectionPS3::*SNPS3ThreadFunc)(void);

public:
	static bool Initialize();
	static void Shutdown();

	static bool RefreshConnections();

private:
	static void ExecuteRefreshConnections();

	static int SNPS3Thread(void *pParameter);

	// Callbacks
private:
	static int __stdcall SNPS3EnumerateTargetsCallback(HTARGET hTarget, void *pUser);
	static void __stdcall SNPS3TTYEventAllStreamsCallback(HTARGET hTarget, UINT eventType, UINT parameter, SNRESULT snResult, UINT length, BYTE *pData, void *pUser);
	static void __stdcall SNPS3FTPEvenCallback(HTARGET hTarget, UINT eventType, UINT parameter, SNRESULT snResult, UINT length, BYTE *pData, void *pUser);

private:
	static SNPS3TMDynamicAPI *s_pSNP3;
	static HANDLE s_hSNPS3Thread;
	static LONG s_bSNPS3ThreadExecute;
	static LONG s_bSNPS3ThreadRefreshConnections;
	static CConnectionPS3 *s_pSNPS3ThreadConnection;
	static void **s_pSNPS3ThreadParameters;
	static void *s_pSNPS3ThreadReturn;
	static SNRESULT s_snResult;

	static HANDLE s_hSNPS3EventExecuteBegin;
	static HANDLE s_hSNPS3EventExecuteEnd;

	static HANDLE s_hSNPS3EventFTP;

private:
	CConnectionPS3(const SNPS3TargetInfo &targetInfo);
	~CConnectionPS3();

private:
	bool PathList(const char *remotePath, bool bFiles, std::vector<string> &result);

	void ExecuteOpen();
	void ExecuteClose();

//	void ExecuteDirectoryCreate();
//	void ExecuteDirectoryDelete();
	void ExecuteDirectoryList();

	void ExecuteFileCopyTo();
	void ExecuteFileCopyFrom();
	void ExecuteFileDelete();
	void ExecuteFileList();

//	void ExecuteSetLastChangeTime();
//	void ExecuteGetLastChangeTime();

	void ExecuteLaunch();

	void ExecuteReset();
	void ExecuteHasActiveProcesses();

	void SNPS3ThreadExecute();

	IConnection* GetPCConnection();

	// IConnection
public:
	virtual void Release() { delete this; }

	virtual const char *GetType() { return "PS3"; }
	virtual const char *GetName();

	virtual bool Open();
	virtual void Close();

	virtual bool SendCommand(const char *command, char *response, size_t &length);

	//	virtual bool DirectoryCreate(const char *remotePath);
	//	virtual bool DirectoryDelete(const char *remotePath);
	virtual bool DirectoryList(const char *remotePath, std::vector<string> &directories);

	virtual bool FileCopyTo(const char *localSource, const char *remoteDestination, bool bSilent);
	virtual bool FileCopyFrom(const char *remoteSource, const char *localDestination, bool bSilent);
	virtual bool FileDelete(const char *remotePath);
	virtual bool FileList(const char *remotePath, std::vector<string> &files);

	virtual bool FileSetLastChangeTime(const char *remotePath, const SFileTime &fileTime) { return false; }
	virtual bool FileGetLastChangeTime(const char *remotePath, SFileTime &fileTime);

	virtual bool Launch(const char *localBuildsPath, const char *remotePath, const char *projectDirectory, const char *application, const char *level);

	virtual void CleanBuild(const string &targetdir);

	virtual bool Reset();
	virtual bool HasActiveProcesses();

	virtual bool IsLocalTargetBuild() { return true; }
	virtual bool IsTargetConnected() { return m_bConnected; }

private:
	SNPS3TargetInfo m_targetInfo;
	bool m_bConnected;

	SNPS3ThreadFunc m_snps3ThreadFunc;
	SNRESULT m_bSNPS3FTPEventResult;

	DWORD m_snps3FTPEventLastTime;
	UINT m_snps3FTPCurrentID;
	CRITICAL_SECTION m_snps3FTPCurrentIDCritialSection;
};

} // namespace RemoteControl
