#pragma once

#include <xbdm.h>
#include "ConnectionManager.h"

namespace RemoteControl {

class CConnectionXB360 :
	public CConnection
{
public:
	static bool RefreshConnections();

private:
	static bool IsPathLevel(const char *path);
	static bool RetrieveLevels(const char *path, size_t rootLength, std::vector<string> &levels);

	static DWORD __stdcall DmNotificationProcess(const CHAR *notification);

private:
	static std::map<unsigned int, CConnectionXB360 *> s_notificationToConnection;

public:
	CConnectionXB360();
private:
	~CConnectionXB360();

private:
	void LogError(HRESULT hResult);

	bool ApplicationConnection();

	bool UploadBuildRecursion(const char *localPath, const char *remotePath, const char *pathSub);

	// IConnection
public:
	virtual void Release() { delete this; }

	virtual const char *GetType() { return "XB360"; }
	virtual const char *GetName();

	virtual bool Open();
	virtual void Close();

	virtual bool SendCommand(const char *command, char *response, size_t &length);

	virtual bool DirectoryCreate(const char *remoteDirectory);
	virtual bool DirectoryDelete(const char *remoteDirectory);
	virtual bool DirectoryList(const char *remotePath, std::vector<string> &directories);

	virtual bool FileCopyTo(const char *localSource, const char *remoteDestination, bool bSilent);
	virtual bool FileCopyFrom(const char *remoteSource, const char *localDestination, bool bSilent);
	virtual bool FileDelete(const char *remotePath);
	virtual bool FileList(const char *remotePath, std::vector<string> &files);

	virtual bool FileSetLastChangeTime(const char *remotePath, const SFileTime &fileTime);
	virtual bool FileGetLastChangeTime(const char *remotePath, SFileTime &fileTime);

	virtual bool Launch(const char *localBuildsPath, const char *remotePath, const char *projectDirectory, const char *application, const char *level);

	virtual void CleanBuild(const string &targetdir);

	virtual bool IsLocalTargetBuild() { return false; }
	virtual bool IsTargetConnected() { return m_bConnected; }

private:
	PDM_CONNECTION m_pdmConnection;
	PDMN_SESSION m_pdmnSession;
	bool m_bConnected;
};

} // namespace RemoteControl
