#ifndef HEADER_CryNotificationNetworkClient
#define HEADER_CryNotificationNetworkClient

#pragma comment(lib, "wsock32.lib") 
#include <WinSock2.h>

#define EWOULDBLOCK 0x2733
#define GetLastError() WSAGetLastError()


//

static const unsigned short NN_PORT = 9432;

static const unsigned int NN_CHANNEL_NAME_LENGTH_MAX = 16;

static const unsigned int NN_PACKET_HEADER_LENGTH = 2 * sizeof(unsigned int) + NN_CHANNEL_NAME_LENGTH_MAX;
static const unsigned int NN_PACKET_HEADER_ID = 0xbada2217;

static const unsigned int NN_PACKET_HEADER_OFFSET_ID = 0;
static const unsigned int NN_PACKET_HEADER_OFFSET_DATA_LENGTH = sizeof(unsigned int);
static const unsigned int NN_PACKET_HEADER_OFFSET_CHANNEL = sizeof(unsigned int)+sizeof(unsigned int);

//

class CCryNotificationNetworkClient
{
public:
	static CCryNotificationNetworkClient *Create(const char *address, unsigned short port = NN_PORT)
	{
		sockaddr_in addr;
		addr.sin_family = AF_INET;
		addr.sin_port = htons(port);

		if (hostent *pHost = gethostbyname(address))
			addr.sin_addr.s_addr = ((in_addr *)(pHost->h_addr))->s_addr;
		else
			addr.sin_addr.s_addr = ::inet_addr(address);

		SOCKET s = ::socket(AF_INET, SOCK_STREAM, NULL);
		if (s < 0 || s == INVALID_SOCKET)
		{
//			gEnv->pLog->Log("CNotificationNetworkSocketClient::Create: Failed to create socket.");
			return NULL;
		}

		static const int yes = 1;
		if (::setsockopt(s, SOL_SOCKET, SO_REUSEADDR,
			(const char *)&yes, sizeof(int)) < 0)
		{
			::closesocket(s);
			s = INVALID_SOCKET;
//			gEnv->pLog->Log("CNotificationNetworkSocketClient::Create: Failed to set SO_REUSEADDR option.");
			return NULL;
		}

		if (::connect(s, (sockaddr *)&addr, sizeof(addr)) < 0)
		{
			::closesocket(s);
			s = INVALID_SOCKET;
//			gEnv->pLog->Log("CNotificationNetworkSocketClient::Create: Failed to connect.");
			return NULL;
		}

		CCryNotificationNetworkClient *pSocket =
			new CCryNotificationNetworkClient();
		pSocket->m_socket = s;
		return pSocket;
	}

private:
	CCryNotificationNetworkClient()
	{
		m_socket = INVALID_SOCKET;
	}

	~CCryNotificationNetworkClient()
	{
		::closesocket(m_socket);
	}

public:
	void Update()
	{
	}

	// INotificationNetworkClient
public:
	void Release() { delete this; }

	bool Send(const char *channel, const void *pBuffer, size_t length)
	{
		size_t channelLength = ::strlen(channel);
//		CRY_ASSERT(channelLength <= NN_CHANNEL_NAME_LENGTH_MAX);

		char header[NN_PACKET_HEADER_LENGTH];
		::memset(header, 0, NN_PACKET_HEADER_LENGTH);

		*(unsigned int *)&header[NN_PACKET_HEADER_OFFSET_ID] = htonl(NN_PACKET_HEADER_ID);
		*(unsigned int *)&header[NN_PACKET_HEADER_OFFSET_DATA_LENGTH] = htonl((u_long)length);
		::memcpy(&header[NN_PACKET_HEADER_OFFSET_CHANNEL], channel, channelLength);

		int sent = 0;
		while (sent < NN_PACKET_HEADER_LENGTH)
		{
			int r = ::send(m_socket, (const char *)header + sent, NN_PACKET_HEADER_LENGTH - sent, NULL);
			if (r < 0)
			{
				const char *errorMessage = ::strerror(GetLastError());
				return false;
			}

			sent += r;
		}

		sent = 0;
		while (sent < length)
		{
			int r = ::send(m_socket, (const char *)pBuffer + sent, length - sent, NULL);
			if (r < 0)
			{
				const char *errorMessage = ::strerror(GetLastError());
				return false;
			}

			sent += r;
		}

		return true;
	}

private:
	SOCKET m_socket;
};

#endif // HEADER_CryNotificationNetworkClient
