#include "StdAfx.h"
#include "FileUtil.h"
#include <io.h>

FolderParseUtil &FolderParseUtil::Instance()
{
	static FolderParseUtil instance;
	return instance;
}

FolderParseUtil::FolderParseUtil()
{
}

FolderParseUtil::~FolderParseUtil()
{
}

bool FolderParseUtil::BackupFolder( const string & path )
{
	string backuppath = path + "backup";
	RemoveDirectory(backuppath);
	MakeDirectory(backuppath);

	for ( CleanItemListIterator item = CleanItems.begin(), end = CleanItems.end(); item != end; ++item )
	{
		if ( !IgnoreBinaryFileOrFolder((*item),false) )
		{
			string sourcepath = FolderParseUtil::Join(path,(*item));
			string destination = backuppath;

			::replace_chars(destination, '/', '\\');
			::replace_chars(sourcepath, '/', '\\');

			char source[MAX_PATH];
			::strncpy(source, sourcepath.c_str(), sizeof(source)-2 );
			source[::strlen(source)+1] = '\0';

			char dest[MAX_PATH];
			::strncpy(dest, destination.c_str(), sizeof(dest)-2);
			dest[::strlen(dest)+1] = '\0';

			SHFILEOPSTRUCT shFileOp;
			shFileOp.hwnd = NULL;
			shFileOp.wFunc = FO_MOVE;
			shFileOp.pFrom = source;
			shFileOp.pTo = dest;
			shFileOp.fFlags = FOF_NOCONFIRMATION | FOF_NOCONFIRMMKDIR | FOF_SILENT | FOF_NOERRORUI;

			::SHFileOperation(&shFileOp);
		}
	}
	
	return true;
}

bool FolderParseUtil::ScanDirectory( const string &path, std::vector<string> &directories, bool recursive, const int itemtypes)
{
	return ScanDirectoryRecursive(path,"",directories,recursive,itemtypes);
}

bool FolderParseUtil::ScanDirectoryRecursive( const string &root,const string &path,std::vector<string> &directories, bool recursive, const int itemtypes)
{
	__finddata64_t c_file;
	intptr_t hFile;
	bool anyFound = false;
	string fullPath = Join(root, path);
	string filespec = Join(fullPath,"*.*");

	if ( (hFile = _findfirst64( filespec.c_str(), &c_file )) != -1L )
	{
		do 
		{
			if (c_file.attrib & _A_SUBDIR && itemtypes & eDirectoryItemTypes_Folders) 
			{
				if (c_file.name[0] != '.')
				{
					anyFound = true;
					directories.push_back( Join(fullPath,c_file.name) );
				}
			}
			else if (itemtypes & eDirectoryItemTypes_Files)
			{
				if(c_file.name[0] != '.')
				{
					anyFound = true;
					directories.push_back( Join(fullPath,c_file.name) );
				}
			}
		} while (_findnext64( hFile, &c_file ) == 0);
		_findclose( hFile );
	}

	if (recursive)
	{
		if( (hFile = _findfirst64( filespec.c_str(), &c_file )) != -1L )
		{
			do 
			{
				if (c_file.attrib & _A_SUBDIR && c_file.name[0] != '.')
				{
					if (ScanDirectoryRecursive( root, Join(path, c_file.name),directories,recursive,itemtypes))
					{
						anyFound = true;
					}
				}
			} while (_findnext64( hFile, &c_file ) == 0);
			_findclose( hFile );
		}
	}

	return anyFound;
}

string FolderParseUtil::Join(const string &filepath1, const string &filepath2)
{
	if ( filepath1.empty() )
		return filepath2;

	if ( filepath2.empty() )
		return filepath1;

	string seperator = "";
	const char p1end = *(filepath1.end()-1);
	const char p2start = *(filepath2.begin());
	if ( (p1end != '\\' && p1end != '/') && (p2start != '\\' && p2start != '/') )
	{
		seperator = "\\";
	}
	return filepath1 + seperator + filepath2;
}

bool FolderParseUtil::RemoveDirectory(const string &path)
{
	string sourcepath = path; 
	::replace_chars(sourcepath, '/', '\\');
	if ( sourcepath[sourcepath.length()-1] == '\\' )
		sourcepath = sourcepath.substr(0,sourcepath.length()-1);
	
	char source[MAX_PATH];
	::strncpy(source, sourcepath.c_str(), sizeof(source)-2 );
	source[::strlen(source)+1] = '\0';

	SHFILEOPSTRUCT shFileOp;
	shFileOp.hwnd = NULL;
	shFileOp.wFunc = FO_DELETE;
	shFileOp.pFrom = source;
	shFileOp.pTo = NULL;
	shFileOp.fFlags = FOF_NOCONFIRMATION | FOF_SILENT | FOF_NOERRORUI;

	if (int r = ::SHFileOperation(&shFileOp))
		return false;

	return true;
}

void FolderParseUtil::MakeDirectory(const string & path)
{
	::CreateDirectory(path.c_str(),NULL);
}

bool FolderParseUtil::FileExists(const string & path)
{
	if (FILE * file = fopen(path.c_str(), "r"))
	{
		fclose(file);
		return true;
	}
	return false;
}

void FolderParseUtil::ParseFoldersToClean(const char * foldersstring)
{
	string tokeniseme = foldersstring;
	int count = 0;
	int prevcount = 0;
	while( (count = tokeniseme.find_first_of(';',prevcount)) != string::npos )
	{
		string token = tokeniseme.substr(prevcount,count-prevcount);
		FolderParseUtil::AddCleanItem(token);
		prevcount = count+1;
	}
}

void FolderParseUtil::ParseBinariesToIgnore(const char * binariesstring)
{
	std::string tokeniseme = binariesstring;
	int count = 0;
	int prevcount = 0;
	while( (count = tokeniseme.find_first_of(';',prevcount)) != string::npos )
	{
		string token = tokeniseme.substr(prevcount,count-prevcount);
		string exttoken = ".ext.";
		IgnoreBinaryItem binaryItem;

		if ( token.compare(0,exttoken.length(),exttoken) == 0 )
		{
			binaryItem.extension = true;
			binaryItem.itemname = token.substr(exttoken.length());
		}
		else
		{
			binaryItem.extension = false;
			binaryItem.itemname = token;
		}

		FolderParseUtil::AddBinaryItem(binaryItem);
		prevcount = count+1;
	}
}

bool FolderParseUtil::IgnoreBinaryFileOrFolder(const string & path, const bool file)
{
	if ( FolderParseUtil::m_ignoreBinaries )
	{
		for ( BinaryItemListIterator item = BinaryItems.begin(), end = BinaryItems.end(); item != end; ++item )
		{
			if ( (*item).extension == file && path.length() >= (*item).itemname.length() && path.compare(path.length()-(*item).itemname.length(),(*item).itemname.length(),(*item).itemname) == 0 )
			{
				return true;
			}
		}
	}
	return false;
}

bool FolderParseUtil::CleanFolder(const string & path)
{
	if ( !IgnoreBinaryFileOrFolder(path,false) )
	{	
		for ( CleanItemListIterator item = CleanItems.begin(), end = CleanItems.end(); item != end; ++item )
		{
			if ( path.length() >= (*item).length() && path.compare(path.length()-(*item).length(),(*item).length(),(*item)) == 0 )
			{
				return true;
			}
		}
	}
	return false;
}

void FolderParseUtil::SetIgnoreBinaries(bool ignoreBinaries)
{
	FolderParseUtil::m_ignoreBinaries = ignoreBinaries;
}

void FolderParseUtil::AddBinaryItem(IgnoreBinaryItem item)
{
	BinaryItems.push_back(item);
}

void FolderParseUtil::AddCleanItem(string item)
{
	CleanItems.push_back(item);
}
