#ifndef __folderutils_buildmanager_h__
#define __folderutils_buildmanager_h__

#pragma once

class FolderParseUtil
{
	public:
		static FolderParseUtil &Instance();

		enum eDirectoryItemTypes
		{
			eDirectoryItemTypes_Files = 1<<0,
			eDirectoryItemTypes_Folders = 1<<1,
		};

	private:
		FolderParseUtil();
		~FolderParseUtil();

	public:
		struct IgnoreBinaryItem
		{
			bool extension;
			std::string itemname;
		};

		typedef std::vector<IgnoreBinaryItem> BinaryItemList;
		typedef std::vector<IgnoreBinaryItem>::iterator BinaryItemListIterator;
		typedef std::vector<string> CleanItemList;
		typedef std::vector<string>::iterator CleanItemListIterator;

	public:
		bool BackupFolder( const string & path );
		bool ScanDirectory( const string &path, std::vector<string> &directories, bool recursive, const int itemtypes = eDirectoryItemTypes_Folders);
		bool ScanDirectoryRecursive( const string &root,const string &path,std::vector<string> &directories, bool recursive, const int itemtypes = eDirectoryItemTypes_Folders);
		string Join(const string &filepath1, const string &filepath2);
		string NormalisePath(string path);
		bool RemoveDirectory(const string &path);
		void MakeDirectory(const string & path);
		bool FileExists(const string & path);

		void ParseFoldersToClean(const char * foldersstring);
		void ParseBinariesToIgnore(const char * binariesstring);
		bool IgnoreBinaryFileOrFolder(const string & path, const bool file);
		bool CleanFolder(const string & path);

		void SetIgnoreBinaries(bool ignoreBinaries);
		void AddBinaryItem(IgnoreBinaryItem item);
		void AddCleanItem(string item);

private:
		bool m_ignoreBinaries;
		BinaryItemList BinaryItems;
		CleanItemList CleanItems;
};

#endif // __folderutils_buildmanager_h__
