#pragma once

#include "ConnectionManager.h"
#include "ThreadManager.h"

class CProjectManager
{
public:
	enum EExclude
	{
		eExclude_Binaries		= 1<<0,
		eExclude_Levels			= 1<<1,
		eExclude_SystemCFG		= 1<<2,
		eClean_Build			= 1<<4,
	};

public:
	class CDesc
	{
	public:
		class CPlatform
		{
		public:
			string buildsDirectory;
			string remotePath;
			string application;
			string project;
		};

	public:
		bool filterIncompleteBuilds;
		string name;
		string localBuildsPath;
		std::map<string, CPlatform> platforms;
	};

public:
	static CProjectManager &Instance();

private:
	static void RoutineUploadBuild(void *pParam);

private:
	CProjectManager();
	~CProjectManager();

public:
	void AddProject(const CDesc &desc) { m_projects.push_back(desc); }
	bool AddProjectFile(const char *path);
	void AddProjectFiles(const char *path);
	
	void ClearProjects();

	size_t GetProjectCount() { return m_projects.size(); }
	const CDesc &GetProjectDesc(size_t index) { return m_projects[index]; }

	bool ActiveProject(size_t index);
	size_t GetActiveProject() { return m_projectActive; }

	bool ActiveConnection(RemoteControl::IConnection *pConnection);
	bool RefreshConnectionCurrent();

	CDesc::CPlatform *GetActivePlatform();

	size_t GetBuildCount() { return m_builds.size(); }
	bool RefreshBuilds() { return RetrieveLocalBuilds(); }
	const char *GetBuildName(size_t index) { return m_builds[index].c_str(); }
	const char *GetBuildRemoteVersion() { return m_remoteVersion.empty() ? NULL : m_remoteVersion.c_str(); }

	bool SetRemotePath(const char *path);
	const char *GetRemotePath();

	bool UploadBuildBegin(size_t index, unsigned int exclude);
	void UploadBuildAbort() { m_uploadBuildAbort = true; }
	bool IsUploadingBuild(bool *pWasSuccessful = NULL);

	size_t GetRemoteLevelCount() { return m_remoteLevels.size(); }
	const char *GetRemoteLevelName(size_t index) { return m_remoteLevels[index].c_str(); }
	bool CalculateBuildServerPath(const string& buildname, string & buildpath);

	void Launch(size_t level);
	void SetFilterBuilds(bool filter);
	bool FilterBuild(const string& buildname);

private:
	bool UploadBuildRecursion(const std::string &path, const std::string &pathSub, bool bForceLowercase);
	bool UploadPC(const char *source, const char *destination);
	bool UploadBuild();

	bool RetrieveLocalBuilds();
	bool RetrieveRemoteBuildVersion();
	bool RetrieveRemoteLevelsRecursion(const char *path, size_t rootLength);
	bool RetrieveRemoteLevels();

	bool IsPathLevel(const char *path);

private:
	ThreadManager::CThread *m_pThread;

	std::vector<CDesc> m_projects;
	size_t m_projectActive;

	RemoteControl::IConnection *m_pConnection;

	std::vector<string> m_builds;
	string m_remotePath;
	string m_remoteVersion;
	std::vector<string> m_remoteLevels;

	size_t m_uploadBuildIndex;
	unsigned int m_uploadBuildExclude;
	bool m_uploadBuildExecuting;
	bool m_uploadBuildAbort;
	bool m_uploadBuildSuccessful;
};
