#pragma once

// Returns the length of the first line in the given string.
inline size_t GetLineLength(const char *text)
{
	const char *current = text;
	while (*current && *current != '\n')
		++current;

	return current - text;
}

/*

  Path

  Naming convention:

  file			A file.
  directory		A directory.
  path			Group of concatenated directories.  If the last character is
				not a slash, the path ends with a file.

*/

namespace Path {

// Returns the length of the first directory in the path.
inline size_t GetDirectoryLength(const char *path)
{
	const char *start = path;

	// Make sure we don't start offsetting before a prepended slash.
	while (*path == '/' || *path == '\\')
		++path;

	while (*path && *path != '/' && *path != '\\')
		++path;

	// If we reached the end of the path and there is no slash, assume it is a
	// file and return 0.
	if (!*path && *(path-1) != '/' && *(path-1) != '\\')
		return 0;

	if (!(path - start))
		return 0;

	return (path - start) + 1;
}

inline size_t GetLengthWithoutFile(const char *path)
{
	const char *a = ::strrchr(path, '/');
	const char *b = ::strrchr(path, '\\');
	if (b)
	{
		if (b > a)
			a = b;
	}

	if (!a)
		return 0;

	return (a - path) + 1;
}

} // namespace Path
