#include "stdafx.h"
#include "TaskManager.h"

#include <Windows.h>
#include <process.h>

using namespace TaskManager;

CTaskManager &CTaskManager::Instance()
{
	static CTaskManager instance;
	return instance;
}

CTaskManager::CTaskManager()
{
	::InitializeCriticalSection(&m_taskVectors);
	m_bThreadExit = false;
	m_bMainThreadOwnsMutex = true;
	m_hThread = ::CreateThread(NULL, NULL, (LPTHREAD_START_ROUTINE)Process, this, NULL, NULL);
	_snprintf(m_mutexName,sizeof(m_mutexName), "taskmanager%d", _getpid());
	m_hMutex = CreateMutex(NULL,true,m_mutexName);
}

CTaskManager::~CTaskManager()
{
	if (m_hThread && m_hMutex)
	{
		m_bThreadExit = true;
		ReleaseMutex(m_hMutex);
		::WaitForSingleObject(m_hThread, INFINITE);
		::WaitForSingleObject(m_hMutex, INFINITE);
		::CloseHandle(m_hThread);
		::CloseHandle(m_hMutex);
		::DeleteCriticalSection(&m_taskVectors);
	}
}

void CTaskManager::AddTask(ITaskObject * task)
{
	::EnterCriticalSection(&m_taskVectors);
	m_threadTasks.insert(m_threadTasks.begin(),task);
	::LeaveCriticalSection(&m_taskVectors);
	::ReleaseMutex(m_hMutex);
}

int CTaskManager::Process(CTaskManager * pTaskManager)
{
	HANDLE mutexHandle = ::OpenMutex(SYNCHRONIZE,true,pTaskManager->m_mutexName); 
	bool bThreadExit = false;
	do 
	{
		WaitForSingleObject(mutexHandle, INFINITE);
		::EnterCriticalSection(&pTaskManager->m_taskVectors);
		bThreadExit = pTaskManager->m_bThreadExit;
		pTaskManager->m_bMainThreadOwnsMutex = false;
		int tasksize = pTaskManager->m_threadTasks.size();
		::LeaveCriticalSection(&pTaskManager->m_taskVectors);
		while ( tasksize > 0 && bThreadExit == false )
		{
			::EnterCriticalSection(&pTaskManager->m_taskVectors);
			ITaskObject * pTask = pTaskManager->m_threadTasks.back();
			pTaskManager->m_threadTasks.pop_back();
			::LeaveCriticalSection(&pTaskManager->m_taskVectors);
			if ( pTask )
			{
				pTask->Process();
				::EnterCriticalSection(&pTaskManager->m_taskVectors);
				pTaskManager->m_finishedTasks.insert(pTaskManager->m_finishedTasks.begin(),pTask);
				::LeaveCriticalSection(&pTaskManager->m_taskVectors);
			}
			::EnterCriticalSection(&pTaskManager->m_taskVectors);
			tasksize = pTaskManager->m_threadTasks.size();
			::LeaveCriticalSection(&pTaskManager->m_taskVectors);
		}
		ReleaseMutex(mutexHandle);
	} while ( !bThreadExit );
	return NULL;
}

void CTaskManager::Tick()
{
	int finishedsize = m_finishedTasks.size();
	while ( finishedsize > 0 )
	{
		ITaskObject * pTask = m_finishedTasks.back();
		m_finishedTasks.pop_back();
		pTask->PostProcess();
		delete pTask;
		pTask = NULL;
		break;
	}
	
	int taskssize = m_threadTasks.size();
	bool owns = m_bMainThreadOwnsMutex;
	
	if ( finishedsize == 0 && taskssize == 0 && owns == false)
	{
		if ( WaitForSingleObject(m_hMutex,500) == WAIT_OBJECT_0 )
		{
			m_bMainThreadOwnsMutex = true;
		}
	}
}
