#pragma once

#include <vector>

namespace TaskManager
{
	class ITaskObject
	{
		public:
			virtual void Process() = 0;
			virtual void PostProcess() = 0;
	};

	class CTaskManager
	{
		public:
			static CTaskManager & Instance();

		private:
			CTaskManager();
			~CTaskManager();

		public:
			void AddTask(ITaskObject * task);
			static int Process(CTaskManager * pTaskManager);
			void Tick();

		private:
			std::vector<ITaskObject*> m_threadTasks;
			std::vector<ITaskObject*> m_finishedTasks;
			CRITICAL_SECTION m_taskVectors;
			HANDLE m_hThread;
			HANDLE m_hMutex;
			char m_mutexName[256];
			bool m_bThreadExit;
			bool m_bMainThreadOwnsMutex;

	};
}