#include "stdafx.h"
#include "ThreadManager.h"
using namespace ThreadManager;

/*

  CTask::CManager

*/

CTask::CManager::CManager()
{
	::InitializeCriticalSection(&m_tasksCriticalSection);
}

CTask::CManager::~CManager()
{
	for (size_t i=0; i<m_tasks.size(); ++i)
		delete m_tasks[i];
	m_tasks.clear();

	::DeleteCriticalSection(&m_tasksCriticalSection);
}

/*

  CTask

*/

CTask::CManager CTask::s_manager;

//

CTask *CTask::Create(FProc proc, void *pParam)
{
	CTask *pTask = NULL;

	::EnterCriticalSection(&s_manager.m_tasksCriticalSection);
	
	if (!s_manager.m_tasks.empty())
	{
		pTask = s_manager.m_tasks.back();
		s_manager.m_tasks.pop_back();
	}

	::LeaveCriticalSection(&s_manager.m_tasksCriticalSection);

	if (!pTask)
		pTask = new CTask();

	pTask->m_proc = proc;
	pTask->m_pParam = pParam;
	return pTask;
}

//

CTask::CTask()
{
}

CTask::~CTask()
{
}

//

void CTask::Release()
{
	::EnterCriticalSection(&s_manager.m_tasksCriticalSection);
	s_manager.m_tasks.push_back(this);
	::LeaveCriticalSection(&s_manager.m_tasksCriticalSection);
}

/*

  CThread

*/

CThread *CThread::Create()
{
	CThread *pThread = new CThread();

	::InitializeCriticalSection(&pThread->m_tasksCriticalSection);

	pThread->m_hTasksEventNew = ::CreateEvent(NULL, FALSE, FALSE, NULL);

	pThread->m_hThread = ::CreateThread(
		NULL, NULL, (LPTHREAD_START_ROUTINE)Routine, pThread, NULL, NULL);

	return pThread;
}

//

int CThread::Routine(CThread *pThread)
{
	bool bThreadExit = false;
	CTask *pTask = NULL;

	for (;;)
	{
		::WaitForSingleObject(pThread->m_hTasksEventNew, INFINITE);

		::EnterCriticalSection(&pThread->m_tasksCriticalSection);

		bThreadExit = pThread->m_bThreadExit;
		pTask = NULL;

		if (!pThread->m_tasks.empty())
		{
			pTask = pThread->m_tasks.back();
			pThread->m_tasks.pop_back();
		}
		if (!pThread->m_tasks.empty())
		{
			// If we have pending tasks set the event to signaled status.
			::SetEvent(pThread->m_hTasksEventNew);
		}

		::LeaveCriticalSection(&pThread->m_tasksCriticalSection);

		if (pTask)
		{
			if (!bThreadExit)
				pTask->m_proc(pTask->m_pParam);
			pTask->Release();
		}

		if (bThreadExit)
			break;
	}

	return NULL;
}

//

CThread::CThread()
{
	m_hThread = NULL;
	m_bThreadExit = false;
}

CThread::~CThread()
{
	if (m_hThread)
	{
		::EnterCriticalSection(&m_tasksCriticalSection);
		m_bThreadExit = true;
		::LeaveCriticalSection(&m_tasksCriticalSection);
		::SetEvent(m_hTasksEventNew);
		::WaitForSingleObject(m_hThread, INFINITE);
		::CloseHandle(m_hThread);
	}

	if (m_hTasksEventNew)
		::CloseHandle(m_hTasksEventNew);

	::DeleteCriticalSection(&m_tasksCriticalSection);
}

//

CTask *CThread::CreateTask(CTask::FProc proc, void *pParam)
{
	CTask *pTask = CTask::Create(proc, pParam);
	if (!pTask)
		return NULL;

	::EnterCriticalSection(&m_tasksCriticalSection);
	m_tasks.push_back(pTask);
	::LeaveCriticalSection(&m_tasksCriticalSection);

	::SetEvent(m_hTasksEventNew);

	return pTask;
}
