#pragma once

namespace ThreadManager {

class CTask;
class CThread;

//

class CTask
{
protected:
	friend CThread;

public:
	typedef void (*FProc)(void *);

private:
	class CManager
	{
	public:
		CManager();
		~CManager();

	public:
		std::vector<CTask *> m_tasks;
		CRITICAL_SECTION m_tasksCriticalSection;
	};

public:
	static CTask *Create(FProc proc, void *pParam);

private:
	static CManager s_manager;

private:
	CTask();
	~CTask();

private:
	void Release();

public:
	void WaitForTask();

private:
	FProc m_proc;
	void *m_pParam;
};

class CThread
{
public:
	static CThread *Create();

private:
	static int Routine(CThread *pThread);

private:
	CThread();
	~CThread();

public:
	void Release() { delete this; }

	CTask *CreateTask(CTask::FProc proc, void *pParam);

private:
	HANDLE m_hThread;
	bool m_bThreadExit;


	CRITICAL_SECTION m_tasksCriticalSection;
	HANDLE m_hTasksEventNew;
	std::vector<CTask *> m_tasks;
};

} // ThreadManager
