using System;
using System.Collections.Generic;
using System.Text;

namespace BuildTools
{
	public class BuildInfo : IComparable<BuildInfo>
	{
		private int _number;
		private string _fullPath;
		private DateTime _dateTime;
		private Platform _platform;

		public BuildInfo(int number, Platform platform, DateTime date, string fullPath)
		{
			_number = number;
			_platform = platform;
			_dateTime = date;
			_fullPath = fullPath;
		}

		public int Number
		{
			get { return _number; }
		}

		public DateTime DateTime
		{
			get { return _dateTime; }
		}

		public string FullPath
		{
			get { return _fullPath; }
		}

		public string DirectoryName
		{
			get
			{
				int lastIndex = _fullPath.LastIndexOf(@"\");
				return _fullPath.Substring(lastIndex + 1);
			}
		}

		public Platform Platform
		{
			get { return _platform; }
		}

		public int CompareTo(BuildInfo buildInfo)
		{
			return Number.CompareTo(buildInfo.Number);
		}

		public static string GetPlatformString(Platform platform)
		{
			string res = "";

			if (PlatformHelper.IsConsole(platform))
				res = string.Format("_{0}_", platform.ToString().ToUpper());

			return res;
		}
	}
}
