using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.IO;

namespace BuildTools
{
	public class BuildInfoList : BaseBuildInfoList
	{
		private string platformFolder;

		private BuildInfoList(string platformFolder, string project, Platform platform)
			: base(project, platform)
		{
			this.platformFolder = platformFolder;
		}

		public static BuildInfoList CreateWithCustomFolderStructure(string platformFolder, string project, Platform platform)
		{
			return new BuildInfoList(platformFolder, project, platform);
		}

		public static BuildInfoList Create(string buildsFolder, string project, Platform platform)
		{
			string platformFolder = Path.Combine(Path.Combine(buildsFolder, project), platform.ToString());
			return new BuildInfoList(platformFolder, project, platform);
		}

		public string PlatformFolder
		{
			get { return platformFolder; }
		}

		public void Update()
		{
			OnUpdateStart();

			DirectoryInfo platformDirectory = new DirectoryInfo(platformFolder);
			if (platformDirectory.Exists)
			{
				foreach (DirectoryInfo versionDirectory in platformDirectory.GetDirectories())
				{
					OnUpdateDirectory(versionDirectory.Name, versionDirectory.FullName);
				}

				OnUpdateDone();
			}
		}
	}
}
