using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

namespace BuildTools
{
	public delegate void BuildWatcherHandler(BuildInfo buildInfo);

	public class BuildWatcher
	{
		private int m_timerPeriodDefault = 30000;

		private int m_timerPeriod;
		private string m_buildsFolder;
		private string m_project;
		private Platform m_platform;

		private BuildInfoList m_buildInfoList;
		private BuildInfo m_lastBuild;
		private Timer m_timer;
		private List<string> m_skipIntervalExecutables;

		private bool m_SkipActions = false;

		public event BuildWatcherHandler NewBuild;

		private void TimerCallBack(object state)
		{
			if (m_buildInfoList == null)
				InitBuildInfoList();
			else
				if (!ProcessCheck.IsGameOrEditorStarted(m_skipIntervalExecutables))
					UpdateBuildInfoList();
		}

		private void UpdateBuildInfoList()
		{
			if (m_buildInfoList != null)
			{
				m_buildInfoList.Update();
				BuildInfo newLastBuild = m_buildInfoList.GetLastVersion();
				if (newLastBuild != null)
				{
					if (m_lastBuild == null || newLastBuild.CompareTo(m_lastBuild) == 1)
					{
						m_lastBuild = newLastBuild;
						NewBuild(m_lastBuild);
					}
				}
			}
		}

		private void InitBuildInfoList()
		{
			try
			{
				m_buildInfoList = BuildInfoList.Create(m_buildsFolder, m_project, m_platform);
				m_buildInfoList.Update();
				m_lastBuild = m_buildInfoList.GetLastVersion();
			}
			catch (Exception)
			{
				m_buildInfoList = null;
			}
		}

		public BuildWatcher(string buildsFolder, string project, Platform platform, List<string> skipIntervalExecutables)
		{
			m_timerPeriod = m_timerPeriodDefault;
			m_buildsFolder = buildsFolder;
			m_project = project;
			m_platform = platform;
			m_skipIntervalExecutables = skipIntervalExecutables;

			m_buildInfoList = null;
			m_lastBuild = null;
			m_timer = null;
		}

		public int TimerPeriod
		{
			set { m_timerPeriod = value; }
		}

		public bool SkipAction
		{
			set { m_SkipActions = value; }
		}

		public void Start()
		{
			m_timer = new Timer(TimerCallBack, null, 0, m_timerPeriod);
		}

		public void Stop()
		{
			m_timer.Dispose();
		}
	}
}
