using System;
using System.Collections.Generic;
using System.Text;

namespace BuildTools
{
	public class CmdLineArg
	{
		private string _name;

		public CmdLineArg(string name)
		{
			_name = name;
		}

		public string Name
		{
			get { return _name; }
		}

		public virtual string ToRC()
		{
			return _name;
		}

		public virtual string ToWin()
		{
			return _name;
		}

		public virtual string ToPK()
		{
			return _name;
		}
	}

	public class CmdLineArgFlag : CmdLineArg
	{
		public CmdLineArgFlag(string name)
			:	base(name)
		{

		}

		public override string ToRC()
		{
			return string.Format("/{0}", Name);
		}

		public override string ToWin()
		{
			return string.Format("/{0}", Name);
		}

		public override string ToPK()
		{
			return string.Format("-{0}", Name);
		}
	}

	public class CmdLineArgValue : CmdLineArgFlag
	{
		private string _value;

		public CmdLineArgValue(string name, string value)
			:	base(name)
		{
			_value = value;
		}

		public string Value
		{
			get { return _value; }
		}

		public override string ToRC()
		{
			return string.Format("/{0}={1}", Name, Value);
		}

		public override string ToWin()
		{
			return string.Format("/{0}:{1}", Name, Value);
		}

		public override string ToPK()
		{
			return string.Format("-{0}={1}", Name, Value);
		}
	}

	public class CmdLineArgsBuilder
	{
		private ICollection<CmdLineArg> _argCollection;

		public CmdLineArgsBuilder()
		{
			_argCollection = new List<CmdLineArg>();
		}

		public void Append(string name)
		{
			_argCollection.Add(new CmdLineArg(name));
		}

		public void AppendFlag(string name)
		{
			_argCollection.Add(new CmdLineArgFlag(name));
		}

		public void AppendFlag(string name, string value)
		{
			_argCollection.Add(new CmdLineArgValue(name, value));
		}

		public void Clear()
		{
			_argCollection.Clear();
		}

		private delegate string ToDelegate(CmdLineArg cmdLineArg);

		private string To(ToDelegate toDelegate)
		{
			StringBuilder stringBuilder = new StringBuilder();
			foreach (CmdLineArg arg in _argCollection)
			{
				stringBuilder.Append(toDelegate(arg));
				stringBuilder.Append(" ");
			}
			return stringBuilder.ToString();
		}

		public string ToRC()
		{
			return To(delegate(CmdLineArg arg) { return arg.ToRC(); });
		}

		public string ToWin()
		{
			return To(delegate(CmdLineArg arg) { return arg.ToWin(); });
		}

		public string ToPK()
		{
			return To(delegate(CmdLineArg arg) { return arg.ToPK(); });
		}
	}
}
