using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace BuildTools
{
	public class FileUtils
	{
		// does not working with overlapping folder
		public static void Copy(DirectoryInfo source, DirectoryInfo target, ICollection<string> excludeExtensions, bool keepFileIfNewer)
		{
			if (!target.Exists)
				target.Create();

			foreach (FileInfo fileInfo in source.GetFiles())
			{
				if (!SkipCopyngFile(excludeExtensions, fileInfo))
				{
					string destFile = Path.Combine(target.FullName.ToString(), fileInfo.Name);
					Copy(fileInfo, destFile, keepFileIfNewer);
				}
			}

			foreach (DirectoryInfo sourceSubDir in source.GetDirectories())
			{
				DirectoryInfo nextTargetSubDir = target.CreateSubdirectory(sourceSubDir.Name);
				Copy(sourceSubDir, nextTargetSubDir, excludeExtensions, keepFileIfNewer);
			}
		}

		public static void Copy(FileInfo fileInfo, string destFile, bool keepFileIfNewer)
		{
			bool destinationFileExists = File.Exists(destFile);
			if (destinationFileExists)
			{
				if ((File.GetAttributes(destFile) & FileAttributes.ReadOnly) == FileAttributes.ReadOnly)
					File.SetAttributes(destFile, FileAttributes.Archive);
			}

			if (keepFileIfNewer && destinationFileExists)
			{
				FileInfo destFileInfo = new FileInfo(destFile);
				if (destFileInfo.LastWriteTime.CompareTo(fileInfo.LastWriteTime) == -1)
				{
					fileInfo.CopyTo(destFile, true);
				}
			}
			else
			{
				fileInfo.CopyTo(destFile, true);
			}
		}

		private static bool SkipCopyngFile(ICollection<string> excludeExtensions, FileInfo fileInfo)
		{
			bool res = false;

			foreach (string ext in excludeExtensions)
			{
				if (ext.ToLower().Equals(fileInfo.Extension.ToLower()))
				{
					res = true;
					break;
				}
			}

			return res;
		}

		// does not working with overlapping folder
		public static void CopyDirectory(string source, string target, ICollection<string> excludeExtensions, bool keepFileIfNewer)
		{
			DirectoryInfo sourceInfo = new DirectoryInfo(source);
			DirectoryInfo targetInfo = new DirectoryInfo(target);

			Copy(sourceInfo, targetInfo, excludeExtensions, keepFileIfNewer);
		}

		// does not working with overlapping folder
		public static void CopyDirectory(string source, string target, ICollection<string> excludeExtensions)
		{
			CopyDirectory(source, target, excludeExtensions, false);
		}

		// does not working with overlapping folder
		public static void Copy(DirectoryInfo source, DirectoryInfo target)
		{
			Copy(source, target, new List<string>(), false);
		}

		// does not working with overlapping folder
		public static void CopyDirectory(string source, string target)
		{
			CopyDirectory(source, target, new List<string>());
		}

		public static void CopyDirectory(string source, string target, bool keepFileIfNewer)
		{
			CopyDirectory(source, target, new List<string>(), keepFileIfNewer);
		}

		public static void Delete(DirectoryInfo dirInfo)
		{
			foreach (DirectoryInfo sourceSubDir in dirInfo.GetDirectories())
				Delete(sourceSubDir);

			foreach (FileInfo fileInfo in dirInfo.GetFiles())
			{
				if ((File.GetAttributes(fileInfo.FullName) & FileAttributes.ReadOnly) == FileAttributes.ReadOnly)
					File.SetAttributes(fileInfo.FullName, FileAttributes.Archive);

				fileInfo.Delete();
			}

			dirInfo.Delete();
		}

		public static void DeleteDirectory(string dir)
		{
			DirectoryInfo dirInfo = new DirectoryInfo(dir);
			Delete(dirInfo);
		}

		public static string CombinePath(string dir, params string[] args)
		{
			string res = dir;
			foreach (string arg in args)
				res = Path.Combine(res, arg);
			return res;
		}
	}
}
