﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Configuration;

namespace BuildTools
{
	class ProcessCheck
	{
		public static bool IsGameOrEditorStarted(List<string> executables)
		{
			bool res = false;
			foreach (var exeFile in executables)
			{
				res=IsProcessStarted(exeFile);
				if (res) return true;
			}
			return res;
		}

		private static bool IsProcessStarted(string fName)
		{
			fName = System.IO.Path.GetFileNameWithoutExtension(fName.ToLower());
			var fName64 = fName+"64"; // handle also 64 bit mode

			foreach (Process proc in Process.GetProcesses())
			{
				if ((proc.ProcessName.ToLower().Equals(fName)) || (proc.ProcessName.ToLower().Equals(fName64))) return true;
			}
			return false;
		}
	}
}
