using System;

namespace BuildTools
{
	public class RetryAction
	{
		public delegate bool RetryDelegate();

		private RetryDelegate _retryDelegate;
		private int _maxRetryNumber;

		public RetryAction(RetryDelegate retryDelegate, int maxRetryNumber)
		{
			_retryDelegate = retryDelegate;
			_maxRetryNumber = maxRetryNumber;
		}

		public bool Start()
		{
			int numRetry = 0;
			bool res = false;
			while (!res && numRetry < _maxRetryNumber)
			{
				res = _retryDelegate();
				numRetry++;
			}
			return res;
		}
	}
}
