// This is the main DLL file.

#include "stdafx.h"

#include "DebugMonitor.h"
#include "DmWrapper.h"
using namespace DebugMonitor;

namespace
{
	IntPtr ConvertStringToIntPtr(String^ str)
	{
		return System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(str);
	}

	void FreeConvertedString(IntPtr str)
	{
		System::Runtime::InteropServices::Marshal::FreeHGlobal(str);
	}

	void FreeConvertedString(char* str)
	{
		FreeConvertedString((IntPtr)str);
	}

	char* GetStringFromIntPtr(IntPtr str)
	{
		return (char*)(void*) str;
	}

	char* ConvertString(String^ str)
	{
		return GetStringFromIntPtr(ConvertStringToIntPtr(str));
	}
}

Connection::Connection()
	: m_address(nullptr)
	, m_dmConnection(new DmConnection())
{
	
}

Connection::Connection(String^ address)
	: m_address(System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(address))
	, m_dmConnection(new DmConnection((char*)(void*)m_address))
	 
{

}

Connection::~Connection()
{
	delete m_dmConnection;

	if (!m_address.ToPointer())
		System::Runtime::InteropServices::Marshal::FreeHGlobal(m_address);
}

bool Connection::ConnectionEsablished()
{
	return m_dmConnection->ConnectionEstablished();
}

FileManagement::FileManagement()
	:	m_dmFileManagement(new DmFileManagement())
{

}

FileManagement::~FileManagement()
{
	delete m_dmFileManagement;
}

bool FileManagement::SendFile(String^ localSource, String^ remoteDestination)
{
	char* localSourceStr = ConvertString(localSource);
	char* remoteDestinationStr = ConvertString(remoteDestination);

	bool res = m_dmFileManagement->SendFile(localSourceStr, remoteDestinationStr);

	FreeConvertedString(localSourceStr);
	FreeConvertedString(remoteDestinationStr);

	return res; 
}

bool FileManagement::ReceiveFile(String^ remoteSource, String^ localDestination)
{
	char* remoteSourceStr = ConvertString(remoteSource);
	char* localDestinationStr = ConvertString(localDestination);
	bool res = m_dmFileManagement->ReceiveFile(remoteSourceStr, localDestinationStr);

	FreeConvertedString(localDestinationStr);
	FreeConvertedString(remoteSourceStr);

	return res;
}

bool FileManagement::RenameFile(String^ remoteOldName, String^ remoteDestination){
	char* remoteOldNameStr = ConvertString(remoteOldName);
	char* remoteDestinationStr = ConvertString(remoteDestination);

	bool res = m_dmFileManagement->RenameFile(remoteOldNameStr, remoteDestinationStr);

	FreeConvertedString(remoteOldNameStr);
	FreeConvertedString(remoteDestinationStr);

	return res;
}

bool FileManagement::CreateDirectory(String^ directoryName)
{
	char* directoryNameStr = ConvertString(directoryName);
	bool res = m_dmFileManagement->CreateDirectory(directoryNameStr);
	FreeConvertedString(directoryNameStr);
	return res;
}

FileAttribute::FileAttribute(String^ name, bool isDirectory, DateTime^ modified, String^ path)
	: m_name(name)
	, m_isDirectory(isDirectory)
	, m_modified(modified)
	, m_path(path)
{

}

String^ FileAttribute::Name::get()
{
	return m_name;
}

DateTime^ FileAttribute::Modified::get()
{
	return m_modified;
}

bool FileAttribute::IsDirectory::get()
{
	return m_isDirectory;
}


String^ FileAttribute::Path::get()
{
	return m_path;
}

WalkDirectoryEnumerator::WalkDirectoryEnumerator(String^ baseDirectory)
{
	char* baseDirectoryStr = ConvertString(baseDirectory);
	m_walkDirectory = new DmWalkDirectory(baseDirectoryStr);
	FreeConvertedString(baseDirectoryStr);
}

WalkDirectoryEnumerator::~WalkDirectoryEnumerator()
{
	delete m_walkDirectory;
}

bool WalkDirectoryEnumerator::MoveNext()
{
	return m_walkDirectory->MoveNext();
}

FileAttribute^ WalkDirectoryEnumerator::Current::get()
{
	if(m_walkDirectory == NULL || m_walkDirectory->GetModified() <=0)
	{
		throw gcnew Exception("Directory not valid" + gcnew String(m_walkDirectory->GetPath()));
	}
	//GetModified returns a FILETIME value (utc, starting from 1/1/1600)
	DateTime^ tmp = DateTime::FromFileTime(m_walkDirectory->GetModified());

	return gcnew FileAttribute(gcnew String(m_walkDirectory->GetCurrentName()), m_walkDirectory->IsDirectory(), tmp, gcnew String(m_walkDirectory->GetPath()));
}

Object^ WalkDirectoryEnumerator::CurrentOldInterface::get()
{
	return Current;
}

void WalkDirectoryEnumerator::Reset()
{

}

WalkDirectory::WalkDirectory(String^ baseDirectory)
	: m_baseDirectory(baseDirectory)
{

}

System::Collections::Generic::IEnumerator<FileAttribute^>^ WalkDirectory::GetEnumerator()
{
	return gcnew WalkDirectoryEnumerator(m_baseDirectory);
}

System::Collections::IEnumerator^ WalkDirectory::GetEnumeratorOldInterface()
{
	return GetEnumerator();
}

Execution::Execution()
	: m_dmExection(new DmExecution())
{

}

Execution::~Execution()
{
	delete m_dmExection;
}

bool Execution::LaunchTitle(String^ path, String^ title)
{
	char* pathStr = ConvertString(path);
	char* titleStr = ConvertString(title);

	bool res = m_dmExection->LaunchTitle(pathStr, titleStr);

	FreeConvertedString(pathStr);
	FreeConvertedString(titleStr);

	return res;
}

bool Execution::RebootWait()
{
	return m_dmExection->RebootWait();
}

DebugMonitor::XboxSystemInfo::XboxSystemInfo()
{
	DM_SYSTEM_INFO xboxInfo;
	bool success = DmSystemInfo().GetSystemInfo(xboxInfo);
	m_valid = success;

	if(success)
	{
		m_baseKernelVersion = "" + xboxInfo.BaseKernelVersion.Major+ "." + xboxInfo.BaseKernelVersion.Minor + "." + xboxInfo.BaseKernelVersion.Build;
		m_kernelVersion = "" + xboxInfo.KernelVersion.Major + "." + xboxInfo.KernelVersion.Minor + "." + xboxInfo.KernelVersion.Build;
		m_xdkVersion = ""+ xboxInfo.XDKVersion.Major + "." + xboxInfo.XDKVersion.Minor + "." + xboxInfo.XDKVersion.Build;
	}
}
String^ XboxSystemInfo::BaseKernelVersion::get()
{
	return m_baseKernelVersion;
}

String^ XboxSystemInfo::KernelVersion::get()
{
	return m_kernelVersion;
}

String^ XboxSystemInfo::XdkVersion::get()
{
	return m_xdkVersion;
}