#pragma once

using namespace System;

namespace DebugMonitor 
{
	class DmConnection;
	class DmFileManagement;
	class DmExecution;
	class DmWalkDirectory;

	public ref class Connection
	{
	public:
		Connection();
		Connection(String^ address);
		~Connection();

		bool ConnectionEsablished();

	private:
		DmConnection* m_dmConnection;
		IntPtr m_address;
	};

	public ref class FileManagement
	{
	public:
		FileManagement();
		~FileManagement();

		bool SendFile(String^ localSource, String^ remoteDestination);
		bool ReceiveFile(String^ remoteSource, String^ localDestination); 
		bool RenameFile(String^ remoteOldName, String^ remoteDestination);
		bool CreateDirectory(String^ directoryName);

	private:
		DmFileManagement* m_dmFileManagement;
	};

	public ref class FileAttribute
	{
	public:
		FileAttribute(String^ name, bool isDirectory, DateTime^ modified, String^ path);

		property String^ Name
		{
			String^ get();
		}

		property bool IsDirectory
		{
			bool get();
		}

		property DateTime^ Modified
		{
			DateTime^ get();
		}

		property String^ Path
		{
			String^ get();
		}
	private:
		String^ m_name;
		DateTime^ m_modified;
		bool m_isDirectory;
		String^ m_path;
	};

	ref class WalkDirectoryEnumerator : public System::Collections::Generic::IEnumerator<FileAttribute^>
	{
	public:
		WalkDirectoryEnumerator(String^ baseDirectory);
		~WalkDirectoryEnumerator();

		virtual bool MoveNext();

		property FileAttribute^ Current
		{
			virtual FileAttribute^ get();
		}

		property System::Object^ CurrentOldInterface
		{
			virtual System::Object^ get() = System::Collections::IEnumerator::Current::get;
		}

		virtual void Reset();

	private:
		DmWalkDirectory* m_walkDirectory;
	};

	public ref class WalkDirectory : public System::Collections::Generic::IEnumerable<FileAttribute^>
	{
	public:
		WalkDirectory(String^ baseDirectory);

		virtual System::Collections::Generic::IEnumerator<FileAttribute^>^ GetEnumerator();

		virtual System::Collections::IEnumerator^ GetEnumeratorOldInterface() = System::Collections::IEnumerable::GetEnumerator;

	private:
		String^ m_baseDirectory;
	};

	public ref class Execution
	{
	public:
		Execution();
		~Execution();

		bool LaunchTitle(String^ path, String^ title);
		bool RebootWait();

	private:
		DmExecution* m_dmExection;
	};

	public ref class XboxSystemInfo
	{
	public: 
		XboxSystemInfo();
		property String^ BaseKernelVersion{
			String^ get();
		}
		property String^ KernelVersion{
			String^ get();
		}
		property String^ XdkVersion{
			String^ get();
		}
		bool IsValid(){
			return m_valid;
		}
	private:
		String^ m_baseKernelVersion;
		String^ m_kernelVersion;
		String^ m_xdkVersion;
		bool m_valid;
	};
}
