#include "stdafx.h"

#include "DmWrapper.h"
using namespace DebugMonitor;
using namespace std;

using namespace System::Runtime::InteropServices;

DmConnection::DmConnection()
{
	OpenConnection();	
}

DmConnection::DmConnection(const char* xboxName)
{
	::DmSetXboxName(xboxName);
	OpenConnection();
}

void DmConnection::OpenConnection()
{
	m_resultConnection = ::DmOpenConnection(&m_pdmConnection);
}

DmConnection::~DmConnection()
{
	::DmCloseConnection(m_pdmConnection);
}

bool DmConnection::ConnectionEstablished() const
{
	return XBDM_NOERR == m_resultConnection;
}

bool DmFileManagement::SendFile(const char* localSource, const char* remoteDestination) const
{
	return XBDM_NOERR == ::DmSendFileA(localSource, remoteDestination);
}

bool DmFileManagement::ReceiveFile(const char* remoteSource, const char* localDestination) const
{
	return XBDM_NOERR == ::DmReceiveFileA(localDestination, remoteSource);
}

bool DmFileManagement::RenameFile(const char* remoteOldName, const char* remoteDestination) const
{
	return XBDM_NOERR == ::DmRenameFile(remoteOldName, remoteDestination);
}

bool DmFileManagement::CreateDirectory(const char* directoryName) const
{
	return XBDM_NOERR == ::DmMkdir(directoryName);
}

DmWalkDirectory::DmWalkDirectory(const char* baseDirectory)
	: m_walkDir(NULL)
	, m_baseDirectory(baseDirectory)
{

}

DmWalkDirectory::~DmWalkDirectory()
{
	DmCloseDir(m_walkDir);
}

bool DmWalkDirectory::MoveNext()
{
	return XBDM_ENDOFLIST != DmWalkDir(&m_walkDir, m_baseDirectory.c_str(), &m_current);
}

const char* DmWalkDirectory::GetCurrentName() const
{
	return m_current.Name;
}

const __int64 DmWalkDirectory::GetModified() const
{
	__int64 result = m_current.ChangeTime.dwHighDateTime;
	result = result << 32;
	result += m_current.ChangeTime.dwLowDateTime;
	return result;	
}

const char* DmWalkDirectory::GetPath() const
{
	return m_baseDirectory.c_str();
}

bool DmWalkDirectory::IsDirectory() const
{
	return (m_current.Attributes & FILE_ATTRIBUTE_DIRECTORY) == FILE_ATTRIBUTE_DIRECTORY;
}

bool DmExecution::LaunchTitle(const char* path, const char* title) const
{
	return XBDM_NOERR == ::DmSetTitle(path, title, "");
}

bool DmExecution::RebootWait() const
{
	return XBDM_NOERR == ::DmReboot(DMBOOT_WAIT);
}

bool DmSystemInfo::GetSystemInfo(DM_SYSTEM_INFO& systemInfo)
{
	systemInfo.SizeOfStruct = sizeof(DM_SYSTEM_INFO);
 	bool infoFound = XBDM_NOERR == ::DmGetSystemInfo(&systemInfo);

	return infoFound;
}