#pragma once

#include <string>

using namespace System;

namespace DebugMonitor 
{
	class DmConnection
	{
	public:
		DmConnection();
		DmConnection(const char* xboxAddress);
		~DmConnection();

		bool ConnectionEstablished() const;
		
	private:
		void OpenConnection();

		PDM_CONNECTION m_pdmConnection;
		HRESULT m_resultConnection;
	};

	class DmFileManagement
	{
	public:
		bool SendFile(const char* localSource, const char* remoteDestination) const;
		bool ReceiveFile(const char* remoteSource, const char* localDestination) const;
		bool RenameFile(const char* remoteOldName, const char* remoteDestination) const;
		bool CreateDirectory(const char* directoryName) const;
	};

	class DmWalkDirectory
	{
	public:
		DmWalkDirectory(const char* baseDirectory);
		~DmWalkDirectory();
	
		bool MoveNext();
		const char* GetCurrentName() const;
		const char* GetPath() const;
		const __int64 GetModified() const;
		bool IsDirectory() const;

	private:
		PDM_WALK_DIR m_walkDir;
		DM_FILE_ATTRIBUTES m_current;
		std::string m_baseDirectory;
	};

	class DmExecution
	{
	public:
		bool LaunchTitle(const char* path, const char* title) const;
		bool RebootWait() const;
	};

	class DmSystemInfo
	{
	public:
		bool GetSystemInfo(DM_SYSTEM_INFO& systemInfo);
	
	};
}
