﻿using System.IO;

namespace SystemTray
{
	public abstract class AbstractCopyFiles
	{
		public delegate void CopyFileDelegate(FileInfo fileInfo);
		public event CopyFileDelegate OnCopyFile;

		public abstract void Copy();
		public abstract int NumberOfFiles();
		public abstract string TextInfo { get; }

		protected int NumberOfFiles(DirectoryInfo source)
		{
			int res = 0;
			foreach (FileInfo fileInfo in source.GetFiles())
				res++;

			foreach (DirectoryInfo sourceSubDir in source.GetDirectories())
				res += NumberOfFiles(sourceSubDir);

			return res;
		}

		protected void NotifyCopyFile(FileInfo fileInfo)
		{
			OnCopyFile(fileInfo);
		}
	}
}
