using System.IO;

namespace SystemTray
{
	public abstract class AbstractCopyPcFiles : AbstractCopyFiles
	{
		protected void Copy(DirectoryInfo source, DirectoryInfo destionation)
		{
			if (!destionation.Exists)
				destionation.Create();

			foreach (FileInfo fileInfo in source.GetFiles())
			{
				string destFile = Path.Combine(destionation.FullName.ToString(), fileInfo.Name);
				Copy(fileInfo, destFile);
			}

			foreach (DirectoryInfo sourceSubDir in source.GetDirectories())
			{
				DirectoryInfo destinationSubDir = destionation.CreateSubdirectory(sourceSubDir.Name);
				Copy(sourceSubDir, destinationSubDir);
			}
		}

		protected void Copy(FileInfo fileInfo, string destFile)
		{
			NotifyCopyFile(fileInfo);

			bool destinationFileExists = File.Exists(destFile);
			if (destinationFileExists)
			{
				if ((File.GetAttributes(destFile) & FileAttributes.ReadOnly) == FileAttributes.ReadOnly)
					File.SetAttributes(destFile, FileAttributes.Archive);
			}

			if (destinationFileExists)
			{
				FileInfo destFileInfo = new FileInfo(destFile);
				if (destFileInfo.LastWriteTime.CompareTo(fileInfo.LastWriteTime) == -1)
				{
					fileInfo.CopyTo(destFile, true);
				}
			}
			else
			{
				fileInfo.CopyTo(destFile, true);
			}
		}
	}
}
