using System;
using System.IO;
using DebugMonitor;

namespace SystemTray
{
	abstract class AbstractCopyXbox360Files : AbstractCopyFiles
	{
		Connection m_connection;
		FileManagement m_fileManagement;

		public AbstractCopyXbox360Files(bool useDefault, string address)
		{
			m_connection = (useDefault) ? new Connection() : new Connection(address);
			m_fileManagement = new FileManagement();
		}

		public bool ConnectionEsablished()
		{
			return m_connection.ConnectionEsablished();
		}

		protected void CreateDirectory(string directoryName)
		{
			m_fileManagement.CreateDirectory(directoryName);
		}

		protected void Copy(string basePath, DirectoryInfo sourceDir)
		{
			string path = Path.Combine(basePath, sourceDir.Name);
			CreateDirectory(path);

			foreach (FileInfo fileInfo in sourceDir.GetFiles())
			{
				Copy(path, fileInfo);
			}

			foreach (DirectoryInfo sourceSubDir in sourceDir.GetDirectories())
			{
				Copy(path, sourceSubDir);
			}
		}

		protected void Copy(string basePath, FileInfo sourceFile)
		{
			string destFile = Path.Combine(basePath, sourceFile.Name);

			NotifyCopyFile(sourceFile);
			m_fileManagement.SendFile(sourceFile.FullName, destFile);
		}
	}
}
