using System;
using System.Collections.Generic;
using BuildTools;

namespace SystemTray
{
	class BuildWatchers
	{
		private ICollection<BuildWatcher> m_watchers;

		public delegate void OnNewBuildDelegate(BuildInfo buildInfo);
		public event OnNewBuildDelegate OnNewBuild;

		public BuildWatchers(string buildsFolder, string project, int timePeriod, List<string> skipIntervalExecutables)
		{
			m_watchers = new List<BuildWatcher>();
			InitWatchers(buildsFolder, project, timePeriod,skipIntervalExecutables);
		}

		private void InitWatchers(string buildsFolder, string project, int timePeriod, List<string> skipIntervalExecutables)
		{
			foreach (Platform platform in Enum.GetValues(typeof(Platform)))
			{
				BuildWatcher buildWatcher = new BuildWatcher(buildsFolder, project, platform,skipIntervalExecutables);
				m_watchers.Add(buildWatcher);
				buildWatcher.TimerPeriod = timePeriod;
				buildWatcher.NewBuild += OnNewBuildFound;
				buildWatcher.Start();
			}
		}

		private void OnNewBuildFound(BuildInfo buildInfo)
		{
			OnNewBuild(buildInfo);
		}

		public void Stop()
		{
			foreach (BuildWatcher buildWatcher in m_watchers)
				buildWatcher.Stop();
		}

		public void SkipActions(bool skipActions)
		{
			foreach (BuildWatcher buildWatcher in m_watchers)
				buildWatcher.SkipAction = skipActions;
		}

	}
}
